"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentQuotationService = void 0;
class AgentQuotationService {
    constructor(quotationRepository) {
        this.quotationRepository = quotationRepository;
    }
    async createQuotation(data, agentId) {
        try {
            const quotation = await this.quotationRepository.createQuotation(data, agentId);
            console.log("Quotation created in service:", quotation);
            return quotation;
        }
        catch (error) {
            console.error("Service error while creating quotation:", error);
            throw error;
        }
    }
    async getQuotationById(id) {
        try {
            return await this.quotationRepository.getQuotationById(id);
        }
        catch (error) {
            console.error("Service error:", error);
            throw error;
        }
    }
    async getAllQuotations(agentId) {
        try {
            const quotations = await this.quotationRepository.getAllQuotations(agentId);
            console.log("Quotations fetched successfully:", quotations);
            return quotations;
        }
        catch (error) {
            console.error("Error in AgentQuotationService.getAllQuotations:", error);
            throw new Error("Failed to fetch quotations");
        }
    }
    async updateQuotation(id, data) {
        try {
            const response = await this.quotationRepository.updateQuotation(id, data);
            console.log("Response in Service layer update", response);
            return response;
        }
        catch (error) {
            console.error("Service error updating quotation:", error);
            throw error;
        }
    }
    async deleteQuotation(id) {
        try {
            const response = await this.quotationRepository.deleteQuotation(id);
            return response;
        }
        catch (error) {
            console.error("Service error deleting quotation:", error);
            throw error;
        }
    }
}
exports.AgentQuotationService = AgentQuotationService;
//# sourceMappingURL=AgentQuotationService.js.map