"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentLeadService = void 0;
class AgentLeadService {
    constructor(agentLeadRepository) {
        this.agentLeadRepository = agentLeadRepository;
    }
    async createLead(leadData) {
        try {
            const newLead = await this.agentLeadRepository.createLead(leadData);
            console.log("New lead created by agent:", newLead);
            return newLead;
        }
        catch (error) {
            console.error("Error creating lead in agent service:", error);
            throw error;
        }
    }
    async getLeads(agentId) {
        try {
            const leads = await this.agentLeadRepository.getAgentLeads(agentId);
            return leads;
        }
        catch (error) {
            console.error("Error getting leads in agent service:", error);
            throw error;
        }
    }
    async getLeadById(leadId, agentId) {
        try {
            const lead = await this.agentLeadRepository.getLeadById(leadId, agentId);
            return lead;
        }
        catch (error) {
            console.error("Error getting lead by ID in agent service:", error);
            throw error;
        }
    }
    async updateLead(leadId, agentId, leadData) {
        try {
            const updatedLead = await this.agentLeadRepository.updateLead(leadId, agentId, leadData);
            return updatedLead;
        }
        catch (error) {
            console.error("Error updating lead in agent service:", error);
            throw error;
        }
    }
    async deleteLead(leadId, agentId) {
        try {
            await this.agentLeadRepository.deleteLead(leadId, agentId);
        }
        catch (error) {
            console.error("Error deleting lead in agent service:", error);
            throw error;
        }
    }
    async changeStatus(id, status) {
        return await this.agentLeadRepository.updateLeadStatus(id, status);
    }
    async changeStage(id, stage, userName, notes) {
        return await this.agentLeadRepository.updateLeadStage(id, stage, userName, notes);
    }
}
exports.AgentLeadService = AgentLeadService;
//# sourceMappingURL=AgentLeadService.js.map