import { LeadStage, LeadStatus } from "@prisma/client";
import { Lead } from "../../interfaces/Lead";
import { AgentLeadRepository } from "../../repositories/agent/AgentLeadRepository";
export declare class AgentLeadService {
    private agentLeadRepository;
    constructor(agentLeadRepository: AgentLeadRepository);
    createLead(leadData: Lead): Promise<Lead>;
    getLeads(agentId: string): Promise<Lead[]>;
    getLeadById(leadId: string, agentId: string): Promise<Lead | null>;
    updateLead(leadId: string, agentId: string, leadData: Partial<Lead>): Promise<Lead | null>;
    deleteLead(leadId: string, agentId: string): Promise<void>;
    changeStatus(id: string, status: LeadStatus): Promise<Lead | null>;
    changeStage(id: string, stage: LeadStage, userName?: string, notes?: string): Promise<Lead | null>;
}
//# sourceMappingURL=AgentLeadService.d.ts.map