export declare class TransferService {
    createTransfer(data: any): Promise<{
        vehicleList: {
            id: string;
            optionalPrice: number | null;
            price: number | null;
            pax: string | null;
            maxPax: number | null;
            vehicle: string | null;
            minPax: number | null;
            transferId: string;
        }[];
    } & {
        id: string;
        name: string;
        updatedAt: Date | null;
        supplierId: string | null;
        terms: string | null;
        from: string | null;
        to: string | null;
    }>;
    getTransfers(): Promise<({
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        vehicleList: {
            id: string;
            optionalPrice: number | null;
            price: number | null;
            pax: string | null;
            maxPax: number | null;
            vehicle: string | null;
            minPax: number | null;
            transferId: string;
        }[];
    } & {
        id: string;
        name: string;
        updatedAt: Date | null;
        supplierId: string | null;
        terms: string | null;
        from: string | null;
        to: string | null;
    })[]>;
    getTransferById(id: string): Promise<({
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        vehicleList: {
            id: string;
            optionalPrice: number | null;
            price: number | null;
            pax: string | null;
            maxPax: number | null;
            vehicle: string | null;
            minPax: number | null;
            transferId: string;
        }[];
    } & {
        id: string;
        name: string;
        updatedAt: Date | null;
        supplierId: string | null;
        terms: string | null;
        from: string | null;
        to: string | null;
    }) | null>;
    updateTransfer(id: string, data: any): Promise<{
        vehicleList: {
            id: string;
            optionalPrice: number | null;
            price: number | null;
            pax: string | null;
            maxPax: number | null;
            vehicle: string | null;
            minPax: number | null;
            transferId: string;
        }[];
    } & {
        id: string;
        name: string;
        updatedAt: Date | null;
        supplierId: string | null;
        terms: string | null;
        from: string | null;
        to: string | null;
    }>;
    deleteTransfer(id: string): Promise<{
        vehicleList: {
            id: string;
            optionalPrice: number | null;
            price: number | null;
            pax: string | null;
            maxPax: number | null;
            vehicle: string | null;
            minPax: number | null;
            transferId: string;
        }[];
    } & {
        id: string;
        name: string;
        updatedAt: Date | null;
        supplierId: string | null;
        terms: string | null;
        from: string | null;
        to: string | null;
    }>;
}
//# sourceMappingURL=transferService.d.ts.map