"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestaurantService = void 0;
const restaurantrepository_1 = require("../../repositories/admin/restaurantrepository");
class RestaurantService {
    constructor() {
        this.restaurantRepository = new restaurantrepository_1.RestaurantRepository();
    }
    async createRestaurant(data) {
        try {
            return await this.restaurantRepository.createRestaurant(data);
        }
        catch (error) {
            console.error("Error creating restaurant in service:", error);
            throw error; // Re-throw the error to be handled by the controller
        }
    }
    async getRestaurants() {
        try {
            return await this.restaurantRepository.getRestaurants();
        }
        catch (error) {
            console.error("Error getting restaurants in service:", error);
            throw error; // Re-throw the error to be handled by the controller
        }
    }
    async getRestaurantById(id) {
        try {
            return await this.restaurantRepository.getRestaurantById(id);
        }
        catch (error) {
            console.error("Error getting restaurant by ID in service:", error);
            throw error; // Re-throw the error to be handled by the controller
        }
    }
    async updateRestaurant(id, data) {
        try {
            return await this.restaurantRepository.updateRestaurant(id, data);
        }
        catch (error) {
            console.error("Error updating restaurant in service:", error);
            throw error; // Re-throw the error to be handled by the controller
        }
    }
    async deleteRestaurant(id) {
        try {
            await this.restaurantRepository.deleteRestaurant(id);
        }
        catch (error) {
            console.error("Error deleting restaurant in service:", error);
            throw error; // Re-throw the error to be handled by the controller
        }
    }
}
exports.RestaurantService = RestaurantService;
//# sourceMappingURL=restaurantService.js.map