"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QuotationService = void 0;
class QuotationService {
    constructor(quotationRepository) {
        this.quotationRepository = quotationRepository;
    }
    async createQuotation(data, userName) {
        try {
            const quotation = await this.quotationRepository.createQuotation(data, userName);
            console.log("Quotation created in service:", quotation);
            return quotation;
        }
        catch (error) {
            console.error("Service error while creating quotation:", error);
            throw error;
        }
    }
    async getQuotationById(id) {
        try {
            return await this.quotationRepository.getQuotationById(id);
        }
        catch (error) {
            console.error("Service error:", error);
        }
    }
    async getQuotationByLeadRefNo(leadRefNo) {
        try {
            console.log("LeadRefNo in service", leadRefNo);
            const quotation = await this.quotationRepository.getQuotationByLeadRefNo(leadRefNo);
            console.log("Quotation in service", quotation);
            return quotation;
        }
        catch (error) {
            console.error("Error in QuotationService.getQuotationByLeadRefNo:", error);
            throw new Error("Failed to fetch quotation by lead reference number");
        }
    }
    async getAllQuotations() {
        try {
            const quotations = await this.quotationRepository.getAllQuotations();
            return quotations;
        }
        catch (error) {
            console.error("Error in QuotationService.getAllQuotations:", error);
            throw new Error("Failed to fetch quotations");
        }
    }
    async updateQuotation(id, data) {
        const response = await this.quotationRepository.updateQuotation(id, data);
        console.log("Response in Service layer update", response);
        return response;
    }
    async deleteQuotation(id) {
        const response = await this.quotationRepository.deleteQuotation(id);
        return response;
    }
    async updateQuotationStatus(id, status, userName) {
        try {
            const updated = await this.quotationRepository.updateQuotationStatus(id, status, userName);
            return updated;
        }
        catch (error) {
            console.error("Service: Failed to update status", error);
            throw error;
        }
    }
    async getAcceptedQuotationsByLeadId(leadId) {
        try {
            return await this.quotationRepository.getAcceptedQuotationsByLeadId(leadId);
        }
        catch (error) {
            throw error;
        }
    }
    async duplicateQuotation(id, userName) {
        try {
            const quotation = await this.quotationRepository.duplicateQuotation(id, userName);
            return quotation;
        }
        catch (error) {
            console.error("Service error while duplicating quotation:", error);
            throw error;
        }
    }
}
exports.QuotationService = QuotationService;
//# sourceMappingURL=quotationService.js.map