"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageService = void 0;
class PackageService {
    constructor(packageRepository) {
        this.packageRepository = packageRepository;
    }
    // backend/src/services/packageService.ts
    async createPackage(packageData) {
        try {
            const newPackage = await this.packageRepository.createPackage(packageData);
            return newPackage;
        }
        catch (error) {
            console.error("Error creating package in service:", error);
            throw error;
        }
    }
    async updatePackage(packageId, packageData) {
        try {
            const updatedPackage = await this.packageRepository.updatePackage(packageId, packageData);
            return updatedPackage;
        }
        catch (error) {
            console.error("Error updating package in service:", error);
            throw error;
        }
    }
    async getAllPackages() {
        try {
            const packages = await this.packageRepository.getAllPackages();
            return packages;
        }
        catch (error) {
            console.error("Error getting packages in service:", error);
            throw error;
        }
    }
    async getPackageById(packageId) {
        try {
            const packageItem = await this.packageRepository.getPackageById(packageId);
            return packageItem;
        }
        catch (error) {
            console.error("Error getting package by ID in service:", error);
            throw error;
        }
    }
    async deletePackage(packageId) {
        try {
            await this.packageRepository.deletePackage(packageId);
        }
        catch (error) {
            console.error("Error deleting package in service:", error);
            throw error;
        }
    }
}
exports.PackageService = PackageService;
//# sourceMappingURL=packageService.js.map