import { Omit } from "utility-types";
import { Package } from "../../interfaces/Package";
import { PackageRepository } from "../../repositories/admin/packageRepository";
export declare class PackageService {
    private packageRepository;
    constructor(packageRepository: PackageRepository);
    createPackage(packageData: Omit<Package, "id">): Promise<Package>;
    updatePackage(packageId: string, packageData: Partial<Package>): Promise<Package>;
    getAllPackages(): Promise<Package[]>;
    getPackageById(packageId: string): Promise<Package | null>;
    deletePackage(packageId: string): Promise<void>;
}
//# sourceMappingURL=packageService.d.ts.map