"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeadService = void 0;
class LeadService {
    constructor(leadRepository) {
        this.leadRepository = leadRepository;
    }
    async createLead(leadData, userName) {
        try {
            const newLead = await this.leadRepository.createLead(leadData, userName);
            return newLead;
        }
        catch (error) {
            console.error('Error creating lead in service:', error);
            throw error;
        }
    }
    async getAllLeads() {
        try {
            const leads = await this.leadRepository.getAllLeads();
            return leads;
        }
        catch (error) {
            console.error('Error getting leads in service:', error);
            throw error;
        }
    }
    async getLeadById(leadId) {
        try {
            const lead = await this.leadRepository.getLeadById(leadId);
            return lead;
        }
        catch (error) {
            console.error('Error getting lead by ID in service:', error);
            throw error;
        }
    }
    async updateLead(leadId, leadData) {
        try {
            const updatedLead = await this.leadRepository.updateLead(leadId, leadData);
            return updatedLead;
        }
        catch (error) {
            console.error('Error updating lead in service:', error);
            throw error;
        }
    }
    async deleteLead(leadId) {
        try {
            await this.leadRepository.deleteLead(leadId);
        }
        catch (error) {
            console.error('Error deleting lead in service:', error);
            throw error;
        }
    }
    async fetchLeads(timeframe) {
        try {
            return await this.leadRepository.getLeadsByTimeframe(timeframe);
        }
        catch (error) {
            console.error("Error fetching leads in service:", error);
            throw error;
        }
    }
    async changeStatus(id, status) {
        return await this.leadRepository.updateLeadStatus(id, status);
    }
    async changeStage(id, stage, userName, notes) {
        return await this.leadRepository.updateLeadStage(id, stage, userName, notes);
    }
    async assignLeadToOperations(leadId, operationUserId) {
        try {
            // You can add validations or checks here if needed
            return await this.leadRepository.assignLeadToOperations(leadId, operationUserId);
        }
        catch (error) {
            console.error('Service Error while assigning lead to operations:', error);
            throw new Error('Unable to assign lead to operations.');
        }
    }
    async assignLeadToAssessment(leadId, assessmentUserId) {
        try {
            // You can add validations or checks here if needed
            return await this.leadRepository.assignLeadToAssessment(leadId, assessmentUserId);
        }
        catch (error) {
            console.error('Service Error while assigning lead to assessment:', error);
            throw new Error('Unable to assign lead to assessment.');
        }
    }
    async getQuotationAcceptedLeads() {
        try {
            return await this.leadRepository.findQuotationAcceptedLeads();
        }
        catch (error) {
            console.error("Error in getQuotationAcceptedLeads service:", error);
            throw new Error("Failed to retrieve quotation accepted leads");
        }
    }
}
exports.LeadService = LeadService;
//# sourceMappingURL=leadService.js.map