"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelService = void 0;
class HotelService {
    constructor(hotelRepository) {
        this.hotelRepository = hotelRepository;
    }
    async createHotel(data) {
        return await this.hotelRepository.createHotel(data);
    }
    async getHotels(page = 1, limit = 10, searchTerm = "") {
        return await this.hotelRepository.getHotels(page, limit, searchTerm);
    }
    async getHotelById(id) {
        return await this.hotelRepository.getHotelById(id);
    }
    async updateHotel(id, data) {
        return await this.hotelRepository.updateHotel(id, data);
    }
    async deleteHotel(id) {
        return await this.hotelRepository.deleteHotel(id);
    }
    async createRoom(data) {
        if (!data.name || !data.hotelId) {
            throw new Error("Room name and hotel ID are required");
        }
        const room = await this.hotelRepository.createRoom(data);
        return room;
    }
    async updateRoom(id, data) {
        if (!id || !data)
            throw new Error("Room ID and data are required");
        return await this.hotelRepository.updateRoom(id, data);
    }
    async deleteRoom(id) {
        if (!id)
            throw new Error("Room ID is required");
        return await this.hotelRepository.deleteRoom(id);
    }
    async getRoomById(id) {
        if (!id)
            throw new Error("Room ID is required");
        return await this.hotelRepository.getRoomById(id);
    }
    async getRoomsByHotelId(hotelId) {
        if (!hotelId)
            throw new Error('Hotel ID is required');
        return await this.hotelRepository.getRoomsByHotelId(hotelId);
    }
}
exports.HotelService = HotelService;
//# sourceMappingURL=hotelService.js.map