"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const dashboardRepository_1 = require("../../repositories/admin/dashboardRepository");
const stageLabels = {
    new_lead: "New Leads",
    quotation_created: "Quotation Created",
    quotation_accepted: "Quotation Accepted",
    trip_started: "Trip Started",
    trip_completed: "Trip Completed",
    // Add other stages from your enum here if needed
    canceled: "Canceled",
    // etc.
};
class DashboardService {
    constructor() {
        this.dashboardRepository = new dashboardRepository_1.DashboardRepository();
    }
    async getDashboardData() {
        try {
            const data = await this.dashboardRepository.getDashboardData();
            return data;
        }
        catch (error) {
            console.error("Service Error:", error);
            throw new Error("Service failed to fetch dashboard data");
        }
    }
    async getTopAgents(limit = 5) {
        try {
            return await this.dashboardRepository.getTopAgentsByLeadCount(limit);
        }
        catch (error) {
            console.error("Service Error - getTopAgents:", error);
            throw new Error("Failed to get top agents");
        }
    }
    async getTopSales(limit = 5) {
        try {
            return await this.dashboardRepository.getTopSalesByLeadCount(limit);
        }
        catch (error) {
            console.error("Service Error - getTopSales:", error);
            throw new Error("Failed to get top sales");
        }
    }
    async getLeadFunnelData(period) {
        try {
            const counts = await this.dashboardRepository.getLeadStageCounts(period);
            // Transform the data from { new_lead: 100 } to [{ label: 'New Leads', count: 100 }, ...]
            const formattedData = Object.entries(counts).map(([stage, count]) => ({
                label: stageLabels[stage] || stage, // Use pretty label, fallback to raw name
                count: count,
            }));
            return formattedData;
        }
        catch (error) {
            throw new Error("Failed to get lead funnel data.");
        }
    }
}
exports.DashboardService = DashboardService;
//# sourceMappingURL=dashboardService.js.map