export declare class DashboardService {
    private dashboardRepository;
    constructor();
    getDashboardData(): Promise<{
        totalLeads: number;
        bookedLeads: number;
        newLeads: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        }[];
        userCount: number;
        agentCount: number;
        dataSeries: {
            users: any[];
            agents: any[];
            leads: any[];
            bookings: number[];
        };
    }>;
    getTopAgents(limit?: number): Promise<(import(".prisma/client").Prisma.PickEnumerable<import(".prisma/client").Prisma.LeadGroupByOutputType, ("agentName" | "agentCode")[]> & {
        _count: {
            agentCode: number;
        };
    })[]>;
    getTopSales(limit?: number): Promise<{
        userId: string;
        salesPersonName: string;
        empCode: string;
        leadCount: number;
    }[]>;
    getLeadFunnelData(period: 'all' | '30d' | '90d'): Promise<{
        label: string;
        count: number;
    }[]>;
}
//# sourceMappingURL=dashboardService.d.ts.map