"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttractionService = void 0;
const attractionRepository_1 = require("../../repositories/admin/attractionRepository");
class AttractionService {
    constructor() {
        this.attractionRepository = new attractionRepository_1.AttractionRepository();
    }
    async createAttraction(data) {
        try {
            return await this.attractionRepository.createAttraction(data);
        }
        catch (error) {
            console.error("Error creating attraction in service:", error);
            throw new Error(error.message || "Error creating attraction");
        }
    }
    async getAttractions() {
        return await this.attractionRepository.getAttractions();
    }
    async getAttractionById(id) {
        return await this.attractionRepository.getAttractionById(id);
    }
    async updateAttraction(id, data) {
        return await this.attractionRepository.updateAttraction(id, data);
    }
    async deleteAttraction(id) {
        return await this.attractionRepository.deleteAttraction(id);
    }
}
exports.AttractionService = AttractionService;
//# sourceMappingURL=attractionService.js.map