"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.adminLogin = void 0;
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const dotenv_1 = __importDefault(require("dotenv"));
const adminRepository = __importStar(require("../../repositories/admin/adminRepository"));
const generateJwt_1 = require("../../utils/generateJwt");
// Load environment variables
dotenv_1.default.config();
const SECRET_KEY = process.env.JWT_SECRET;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET;
const adminLogin = async ({ email, password, }) => {
    const admin = await adminRepository.getAdminByEmail(email);
    if (!admin)
        throw new Error("Admin not found");
    const passwordMatch = await bcryptjs_1.default.compare(password, admin.password);
    if (!passwordMatch)
        throw new Error("Invalid credentials");
    if (!admin.role)
        throw new Error("Admin role is missing");
    // Generate access and refresh tokens
    const accessToken = (0, generateJwt_1.generateToken)(admin.id.toString(), admin.role, SECRET_KEY, "7d");
    const refreshToken = (0, generateJwt_1.generateToken)(admin.id.toString(), admin.role, REFRESH_SECRET, "14d");
    console.log("Generated Tokens:", { accessToken, refreshToken });
    return { accessToken, refreshToken, admin };
};
exports.adminLogin = adminLogin;
//# sourceMappingURL=adminService.js.map