"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// backend/src/server.ts
const cors_1 = __importDefault(require("cors"));
const dotenv_1 = __importDefault(require("dotenv"));
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const adminRoutes_1 = __importDefault(require("./routes/adminRoutes"));
const agentRoutes_1 = __importDefault(require("./routes/agentRoutes"));
const userRoutes_1 = __importDefault(require("./routes/userRoutes"));
const http_1 = __importDefault(require("http"));
const socket_io_1 = require("socket.io");
const socket_1 = require("./socket/socket");
dotenv_1.default.config();
const app = (0, express_1.default)();
const server = http_1.default.createServer(app);
const allowedOrigins = [
    "https://ssworldcrm.sixthstar.in",
    "http://kth.sixthstar.org:4000",
    "http://localhost:5173" // Keep localhost for development!
];
const io = new socket_io_1.Server(server, {
    cors: {
        origin: allowedOrigins, // Use the array for Socket.IO as well
        credentials: true,
    },
});
(0, socket_1.initSocket)(io);
// const notificationService = new NotificationService();
app.use((0, cors_1.default)({
    origin: (origin, callback) => {
        if (!origin || allowedOrigins.includes(origin)) {
            callback(null, true);
        }
        else {
            callback(new Error("Not allowed by CORS"));
        }
    },
    credentials: true,
    allowedHeaders: [
        "Authorization",
        "Content-Type",
        "x-user-role",
        "x-refresh-token",
    ],
    exposedHeaders: ["x-access-token", "x-refresh-token"],
    methods: ["GET", "POST", "PUT", "DELETE", "OPTIONS", "PATCH"],
}));
app.use(express_1.default.json());
const agentImagesPath = path_1.default.join(__dirname, "assets", "agent-images");
app.use("/agent-images", express_1.default.static(agentImagesPath));
const packagesPath = path_1.default.join(__dirname, "assets", "packages");
app.use("/assets/packages", express_1.default.static(packagesPath));
// Load Routes Dynamically
async function loadRoutes() {
    app.use("/admin", adminRoutes_1.default);
    app.use("/agent", agentRoutes_1.default);
    app.use("/user", userRoutes_1.default);
}
// Call loadRoutes to load the routes
loadRoutes().catch(err => console.error("Failed to load routes", err));
app.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).json({ message: err.message || "Internal Server Error" });
});
app.use((req, res) => {
    res.status(404).json({ message: "Route not found" });
});
const PORT = process.env.PORT || 5000;
server.listen(PORT, () => console.log(` Server running on port ${PORT}. Accessible via ${process.env.SERVER_URL || "http://localhost"}`));
//# sourceMappingURL=server.js.map