"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
// import { authenticate } from "../middleware/authMiddleware";
const multerConfig_1 = require("../config/multerConfig");
const userAgentController_1 = require("../controllers/user/userAgentController"); // Check the import path correct
const UserLeadController_1 = require("../controllers/user/UserLeadController");
const userLoginController_1 = require("../controllers/user/userLoginController");
const userquotationController_1 = require("../controllers/user/userquotationController");
const authMiddleware1_1 = require("../middlewares/authMiddleware1");
const roleMiddleware_1 = require("../middlewares/roleMiddleware");
const agentRepository_1 = require("../repositories/agent/agentRepository"); //This line is the problem
const userLeadRepository_1 = require("../repositories/user/userLeadRepository");
const userquotationRepository_1 = require("../repositories/user/userquotationRepository");
const agentService_1 = require("../services/agent/agentService");
const UserLeadService_1 = require("../services/user/UserLeadService");
const userquotationService_1 = require("../services/user/userquotationService");
const documentRepository_1 = require("../repositories/user/documentRepository");
const documentService_1 = require("../services/user/documentService");
const documentController_1 = require("../controllers/user/documentController");
// import { BookingRepository } from "../repositories/user/UserBookingRepository";
const UserBookingService_1 = require("../services/user/UserBookingService");
const UserBookingController_1 = require("../controllers/user/UserBookingController");
const UserbookingRepository_1 = require("../repositories/user/UserbookingRepository");
const operationDashboardController_1 = require("../controllers/user/operationDashboardController");
const userGuideController_1 = require("../controllers/user/userGuideController");
const userTourController_1 = require("../controllers/user/userTourController");
const prismaClient_1 = __importDefault(require("../config/prismaClient"));
const userAssessmentRepository_1 = require("../repositories/user/userAssessmentRepository");
const userAssessmentService_1 = require("../services/user/userAssessmentService");
const userAssessmentContoller_1 = require("../controllers/user/userAssessmentContoller");
const UserDashboardController_1 = require("../controllers/user/UserDashboardController");
const UserTeamDashboardService_1 = require("../services/user/UserTeamDashboardService");
const UserTeamDashboardRepository_1 = require("../repositories/user/UserTeamDashboardRepository");
const assessmentDashboardController_1 = require("../controllers/user/assessmentDashboardController");
const notificationController_1 = require("../controllers/common/notificationController");
// import { getUserNotifications } from "../controllers/common/notificationController";
const userDashboardRepository = new UserTeamDashboardRepository_1.UserTeamDashboardRepository();
const userDashboardService = new UserTeamDashboardService_1.UserDashboardService();
const userDashboardController = new UserDashboardController_1.UserDashboardController(userDashboardService);
const userLeadRepository = new userLeadRepository_1.UserLeadRepository();
const userLeadService = new UserLeadService_1.UserLeadService(userLeadRepository);
const userLeadController = new UserLeadController_1.UserLeadController(userLeadService);
const userAssessmentRepository = new userAssessmentRepository_1.UserAssessmentRepository();
const userAssessmentService = new userAssessmentService_1.UserAssessmentService(userAssessmentRepository);
const userAssessmentController = new userAssessmentContoller_1.UserAssessmentController(userAssessmentService); // Create an instance of UserAssessmentController
const quotationRepository = new userquotationRepository_1.QuotationRepository();
const quotationService = new userquotationService_1.QuotationService(quotationRepository);
const quotationController = new userquotationController_1.QuotationController(quotationService);
const agentRepository = new agentRepository_1.AgentRepository();
const agentservice = new agentService_1.agentService(agentRepository);
const agentController = new userAgentController_1.AgentController(agentservice);
const documentRepository = new documentRepository_1.DocumentRepository();
const documentService = new documentService_1.DocumentService(documentRepository);
const documentController = new documentController_1.DocumentController(documentService);
const bookingRepository = new UserbookingRepository_1.BookingRepository();
const bookingService = new UserBookingService_1.BookingService(bookingRepository);
const bookingController = new UserBookingController_1.BookingController(bookingService);
const guideController = new userGuideController_1.GuideController(); // Create an instance of GuideController
const tourController = new userTourController_1.TourController();
// const operationDashboardRouter = express.Router();
const userRouter = express_1.default.Router();
userRouter.post("/login", userLoginController_1.userLogin); // added middleware
userRouter.get("/userdashboard", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        userDashboardController.getUserDashboardData(req, res, next);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.get("/assessmentdashboard", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        (0, assessmentDashboardController_1.getAssessmentDashboardData)(req, res);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.get("/assessmentleadoverview/:timeframe?", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        (0, assessmentDashboardController_1.getAssessmentLeadOverview)(req, res);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.post("/leads", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        userLeadController.createLead(req, res, next);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.get("/leads", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        userLeadController.getUserLeads(req, res, next);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.get("/leads/:leadId", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        userLeadController.getLeadById(req, res, next);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.put("/leads/:leadId", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        userLeadController.updateLead(req, res, next);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.delete("/leads/:leadId", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    try {
        userLeadController.deleteLead(req, res, next);
    }
    catch (error) {
        console.error("Error in userRouter:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
// Quotation routes for users
userRouter.post("/createquotations", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    quotationController.createQuotation(req, res).catch(next);
});
userRouter.get("/quotations", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await quotationController.getQuotations(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.get("/quotations/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await quotationController.getQuotationById(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.patch("/quotationStatus/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await quotationController.updateQuotationStatus(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.put("/quotations/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await quotationController.updateQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.delete("/quotations/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await quotationController.deleteQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.post("/duplicateQuotation/:id", async (req, res, next) => {
    try {
        await quotationController.duplicateQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.get("/getquotationbyleadid/:leadId", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await quotationController.getQuotationByLeadRefNo(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.post("/leads", authMiddleware1_1.authenticateUser, (req, res, next) => userLeadController.createLead(req, res, next));
userRouter.get("/leads", authMiddleware1_1.authenticateUser, (req, res, next) => userLeadController.getUserLeads(req, res, next));
userRouter.get("/leads/:leadId", authMiddleware1_1.authenticateUser, (req, res, next) => userLeadController.getLeadById(req, res, next));
userRouter.put("/leads/:leadId", authMiddleware1_1.authenticateUser, (req, res, next) => userLeadController.updateLead(req, res, next));
userRouter.delete("/leads/:leadId", authMiddleware1_1.authenticateUser, (req, res, next) => userLeadController.deleteLead(req, res, next));
userRouter.put("/leads/:id/status", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    userLeadController.updateStatus(req, res, next).catch(next); // Pass 'next'
});
userRouter.put("/leads/:id/stage", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    userLeadController.updateStage(req, res, next).catch(next); // Pass 'next'
});
// DOCUMENT ROUTES
userRouter.post("/leads/:leadId/documents", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), multerConfig_1.documentUpload.single("document"), // Use documentUpload middleware
async (req, res, next) => {
    try {
        await documentController.uploadDocument(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
userRouter.get("/leads/:leadId/documents", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), async (req, res, next) => {
    try {
        await documentController.getDocumentsForLead(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
userRouter.delete("/documents/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "agent", "user"]), async (req, res, next) => {
    try {
        await documentController.deleteDocument(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
// ==============================================
userRouter.post("/agents/createAgent", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), multerConfig_1.agentUpload.single("image"), // Apply multer middleware here
async (req, res, next) => {
    try {
        await agentController.createAgent(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
userRouter.put("/agents/updateAgent/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), multerConfig_1.agentUpload.single("image"), // Apply multer middleware here
(req, res, next) => agentController.updateAgent(req, res, next));
userRouter.get("/agents", (req, res, next) => agentController.getAllAgents(req, res, next));
userRouter.delete("/agents/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    // Call the deleteAgent method from the agentController
    agentController.softDeleteAgent(req, res, next);
    // If you want to implement hard delete, you can call the deleteAgent method instead
    // agentController.deleteAgent(req, res, next);
    // You can also log the ID of the agent being deleted if needed
    console.log("delete", req.params.id);
});
userRouter.put("/agents/restore/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    agentController.restoreAgent(req, res, next);
});
userRouter.delete("/agents/permenantDelete/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), (req, res, next) => {
    agentController.deleteAgent(req, res, next);
});
userRouter.get("/operation", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "operations"]), operationDashboardController_1.getOperationDashboardData);
userRouter.get("/top5bookings", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "operations"]), operationDashboardController_1.getTop5Bookings);
userRouter.get("/bookingLeadOverview/:timeframe?", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "operations"]), operationDashboardController_1.getBookingLeadOverview);
// ==============================================
// BOOKING MANAGEMENT ROUTES
// ==============================================
userRouter.post("/createBooking", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await bookingController.createBooking(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.get("/bookings", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res) => {
    try {
        await bookingController.getBookings(req, res);
    }
    catch (error) {
        console.log(error);
    }
});
userRouter.get("/bookings/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await bookingController.getBookingById(req, res);
    }
    catch (error) {
        next(error);
    }
});
userRouter.patch("/bookings/:id/status", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateBookingStatus(req, res);
});
userRouter.patch("/bookings/:id/stage", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateBookingStage(req, res);
});
userRouter.patch("/bookings/updateAccommodation/:bookingId/:accommodationId", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateAccommodationHandler(req, res);
});
userRouter.put('/bookings/updateItinerary/:bookingId/:itineraryId', authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateItinerary(req, res);
});
// ==============================================
// TOUR MANAGEMENT ROUTES
// ==============================================
userRouter.get("/tours", (req, res, next) => {
    tourController.getTours(req, res, next).catch(next);
});
userRouter.get("/tours/:id", (req, res, next) => {
    tourController.getTourById(req, res, next).catch(next);
});
// ==============================================
// guide MANAGEMENT ROUTES
// ==============================================
userRouter.get("/guides", (req, res, next) => {
    guideController.getGuides(req, res, next);
});
userRouter.get("/getGuide/:id", (req, res, next) => {
    guideController.getGuideById(req, res, next);
});
userRouter.get("/suppliers", async (req, res) => {
    const suppliers = await prismaClient_1.default.suppliers.findMany(); // Or relevant DB fetch
    res.json(suppliers);
});
userRouter.get("/assessments", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await userAssessmentController.getAllAssessments(req, res);
    }
    catch (error) {
        console.error("Error fetching assessments:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.get("/assessments/:id", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await userAssessmentController.getAssessmentById(req, res);
    }
    catch (error) {
        console.error("Error fetching assessment by ID:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
userRouter.get("/notification", authMiddleware1_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["user"]), async (req, res, next) => {
    try {
        await (0, notificationController_1.getUserNotifications)(req, res);
    }
    catch (error) {
        console.error("Error fetching notifications:", error);
        res.status(500).json({ error: "Internal Server Error" });
    }
});
exports.default = userRouter;
//# sourceMappingURL=userRoutes.js.map