"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
// --- Dependency Imports ---
// Login related
const agentLoginController_1 = require("../controllers/agent/agentLoginController");
// Lead Management Dependencies
const AgentLeadController_1 = require("../controllers/agent/AgentLeadController");
const AgentQuotationController_1 = require("../controllers/agent/AgentQuotationController");
const authMiddleware_1 = require("../middlewares/authMiddleware");
const roleMiddleware_1 = require("../middlewares/roleMiddleware");
const AgentLeadRepository_1 = require("../repositories/agent/AgentLeadRepository");
const AgentQuotationRepository_1 = require("../repositories/agent/AgentQuotationRepository");
const AgentLeadService_1 = require("../services/agent/AgentLeadService");
const AgentQuotationService_1 = require("../services/agent/AgentQuotationService");
// --- End Dependency Imports ---
const agentRouter = express_1.default.Router();
// --- Instantiate Dependencies (if not already done elsewhere) ---
const agentLeadRepository = new AgentLeadRepository_1.AgentLeadRepository();
const agentLeadServiceInstance = new AgentLeadService_1.AgentLeadService(agentLeadRepository);
const agentLeadController = new AgentLeadController_1.AgentLeadController(agentLeadServiceInstance);
const agentQuotationRepository = new AgentQuotationRepository_1.AgentQuotationRepository();
const agentQuotationService = new AgentQuotationService_1.AgentQuotationService(agentQuotationRepository);
const agentQuotationController = new AgentQuotationController_1.AgentQuotationController(agentQuotationService);
// --- Route Definitions ---
// Agent Login Route - Public
agentRouter.post("/login", agentLoginController_1.agentLoginController);
// --- Agent Specific Lead Management Routes ---
// These routes are protected and only accessible by authenticated agents
// POST /agents/leads - Create a new lead for the logged-in agent
agentRouter.post("/leads", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentLeadController.createLead(req, res, next);
});
// GET /agents/leads - Get all leads for the logged-in agent
agentRouter.get("/leads", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentLeadController.getAllLeads(req, res, next); // ✅ CORRECTED METHOD NAME
});
agentRouter.get("/leads/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentLeadController.getLeadById(req, res, next); //  ✅ CORRECTED METHOD NAME
});
// PUT /agents/leads/:leadId - Update a specific lead by ID for the logged-in agent
agentRouter.put("/leads/:leadId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentLeadController.updateLead(req, res, next);
});
// DELETE /agents/leads/:leadId - Delete a specific lead by ID for the logged-in agent
agentRouter.delete("/leads/:leadId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentLeadController.deleteLead(req, res, next);
});
// Quotation routes for agents
agentRouter.post("/quotations", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentQuotationController.createQuotation(req, res).catch(next);
});
agentRouter.get("/quotations", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentQuotationController.getQuotations(req, res).catch(next);
});
agentRouter.get("/quotations/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentQuotationController.getQuotationById(req, res).catch(next);
});
agentRouter.put("/quotations/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentQuotationController.updateQuotation(req, res).catch(next);
});
agentRouter.delete("/quotations/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["agent"]), (req, res, next) => {
    agentQuotationController.deleteQuotation(req, res).catch(next);
});
exports.default = agentRouter;
//# sourceMappingURL=agentRoutes.js.map