"use strict";
// backend/src/routes/adminRoutes.ts
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const adminController_1 = require("../controllers/admin/adminController");
const authController_1 = require("../controllers/authController");
const authMiddleware_1 = require("../middlewares/authMiddleware");
const roleMiddleware_1 = require("../middlewares/roleMiddleware");
// Import all controllers, repositories, and services
const dashboardController_1 = require("../controllers/admin/dashboardController");
const multerConfig_1 = require("../config/multerConfig");
const attractionController_1 = require("../controllers/admin/attractionController");
const hotelController_1 = require("../controllers/admin/hotelController");
const leadController_1 = require("../controllers/admin/leadController");
const packageController_1 = require("../controllers/admin/packageController");
const quotationController_1 = require("../controllers/admin/quotationController");
const restaurantController_1 = require("../controllers/admin/restaurantController");
const supplierController_1 = require("../controllers/admin/supplierController");
const transferController_1 = require("../controllers/admin/transferController");
const agentController_1 = require("../controllers/agent/agentController");
const userController_1 = require("../controllers/admin/userController");
const hotelRepository_1 = require("../repositories/admin/hotelRepository");
const leadRepository_1 = require("../repositories/admin/leadRepository");
const packageRepository_1 = require("../repositories/admin/packageRepository");
const quotationRepository_1 = require("../repositories/admin/quotationRepository");
const teamRepository_1 = require("../repositories/admin/teamRepository");
const agentRepository_1 = require("../repositories/agent/agentRepository");
const hotelService_1 = require("../services/admin/hotelService");
const leadService_1 = require("../services/admin/leadService");
const packageService_1 = require("../services/admin/packageService");
const quotationService_1 = require("../services/admin/quotationService");
const agentService_1 = require("../services/agent/agentService");
const notificationController_1 = require("../controllers/common/notificationController");
const documentController_1 = require("../controllers/admin/documentController");
const documentService_1 = require("../services/admin/documentService");
const documentRepository_1 = require("../repositories/admin/documentRepository");
const guideController_1 = require("../controllers/admin/guideController"); // Import GuideController
const tourRepository_1 = require("../repositories/admin/tourRepository");
const tourService_1 = require("../services/admin/tourService");
const tourController_1 = require("../controllers/admin/tourController");
const bookingRepository_1 = require("../repositories/admin/bookingRepository");
const bookingService_1 = require("../services/admin/bookingService");
const bookingController_1 = require("../controllers/admin/bookingController");
// import { cloudConfigDocument, uploadToCloudDocument } from "../../config/cloudStorageDocument";
// Initialize Router
const adminRouter = express_1.default.Router();
// Initialize Controllers and Services
const hotelRepository = new hotelRepository_1.HotelRepository();
const hotelService = new hotelService_1.HotelService(hotelRepository);
const hotelController = new hotelController_1.HotelController(hotelService);
const restaurantController = new restaurantController_1.RestaurantController();
const agentRepository = new agentRepository_1.AgentRepository();
const agentservice = new agentService_1.agentService(agentRepository);
const agentController = new agentController_1.AgentController(agentservice);
const supplierController = new supplierController_1.SupplierController();
const transferController = new transferController_1.TransferController();
const attractionController = new attractionController_1.AttractionController();
const userController = new userController_1.UserController();
const teamRepository = new teamRepository_1.TeamRepository();
const leadRepository = new leadRepository_1.LeadRepository();
const leadService = new leadService_1.LeadService(leadRepository);
const leadController = new leadController_1.LeadController(leadService);
const packageRepository = new packageRepository_1.PackageRepository();
const packageService = new packageService_1.PackageService(packageRepository);
const packageController = new packageController_1.PackageController(packageService);
const bookingRepository = new bookingRepository_1.BookingRepository();
const bookingService = new bookingService_1.BookingService();
const bookingController = new bookingController_1.BookingController(bookingService);
const quotationRepository = new quotationRepository_1.QuotationRepository();
const quotationService = new quotationService_1.QuotationService(quotationRepository);
const quotationController = new quotationController_1.QuotationController(quotationService, bookingService);
const documentRepository = new documentRepository_1.DocumentRepository();
const documentService = new documentService_1.DocumentService(documentRepository);
const documentController = new documentController_1.DocumentController(documentService);
const guideController = new guideController_1.GuideController(); // Create an instance of GuideController
const tourRepository = new tourRepository_1.TourRepository();
const tourService = new tourService_1.TourService();
const tourController = new tourController_1.TourController();
// ==============================================
// AUTHENTICATION ROUTES
// ==============================================
adminRouter.post("/login", adminController_1.adminLogin);
adminRouter.get("/", dashboardController_1.getDashboardData);
adminRouter.get("/top-agents", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), dashboardController_1.getTopAgents);
adminRouter.get("/top-sales", dashboardController_1.getTopSales);
adminRouter.get("/lead-funnel", (req, res, next) => {
    (0, dashboardController_1.getLeadFunnel)(req, res).catch(next);
});
adminRouter.post("/refresh-token", authController_1.refreshAccessToken);
// ==============================================
// HOTEL MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createHotel", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => hotelController.createHotel(req, res));
adminRouter.get("/hotels", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res, next) => hotelController.getHotels(req, res, next));
adminRouter.get("/getHotel/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res, next) => hotelController.getHotelById(req, res, next));
adminRouter.put("/updateHotel/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => hotelController.updateHotel(req, res, next));
adminRouter.delete("/deleteHotel/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => hotelController.deleteHotel(req, res, next));
adminRouter.post("/createRoom/:hotelId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => hotelController.createRoom(req, res));
adminRouter.put("/updateRoom/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => hotelController.updateRoom(req, res));
adminRouter.delete("/deleteRoom/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => hotelController.deleteRoom(req, res));
adminRouter.get("/getRoom/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res) => hotelController.getRoomById(req, res));
adminRouter.get("/getRooms/:hotelId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res) => hotelController.getRoomsByHotel(req, res));
// ==============================================
// AGENT MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/agents/createAgent", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), multerConfig_1.agentUpload.single("image"), // Apply multer middleware here
(req, res, next) => agentController.createAgent(req, res, next));
adminRouter.put("/agents/updateAgent/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), multerConfig_1.agentUpload.single("image"), // Apply multer middleware here
(req, res, next) => agentController.updateAgent(req, res, next));
adminRouter.get("/agents", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res, next) => agentController.getAllAgents(req, res, next));
adminRouter.delete("/agents/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    agentController.softDeleteAgent(req, res, next);
    console.log("delete", req.params.id);
});
adminRouter.put("/agents/restore/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    agentController.restoreAgent(req, res, next);
});
adminRouter.delete("/agents/permenantDelete/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    agentController.deleteAgent(req, res, next);
});
// ==============================================
// SUPPLIER MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/suppliers", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => supplierController.createSupplier(req, res));
adminRouter.get("/suppliers", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await supplierController.getSuppliers(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/suppliers/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await supplierController.getSupplierById(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.put("/suppliers/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await supplierController.updateSupplier(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.delete("/suppliers/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => supplierController.deleteSupplier(req, res));
// ==============================================
// TRANSFER MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createTransfer", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), transferController.createTransfer);
adminRouter.get("/transfers", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), transferController.getTransfers);
adminRouter.get("/getTransfer/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), transferController.getTransferById);
adminRouter.put("/updateTransfer/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), transferController.updateTransfer);
adminRouter.delete("/deleteTransfer/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), transferController.deleteTransfer);
// ==============================================
// ATTRACTION MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/attractions", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await attractionController.createAttraction(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/attractions", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), attractionController.getAttractions);
adminRouter.get("/attractions/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), attractionController.getAttractionById);
adminRouter.put("/attractions/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), attractionController.updateAttraction);
adminRouter.delete("/attractions/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), attractionController.deleteAttraction);
// ==============================================
// USER MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createuser", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => userController.createUser(req, res));
adminRouter.get("/users", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res) => userController.getUsers(req, res));
adminRouter.get("/users/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => userController.getUserById(req, res));
adminRouter.get("/users/email/:email", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => userController.getUserByEmail(req, res));
adminRouter.put("/updateusers/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => userController.updateUser(req, res));
adminRouter.delete("/deleteuser/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => userController.deleteUser(req, res));
adminRouter.put("/restore/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await userController.restore(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.delete("/permanentdelete/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await userController.deleteUserPermanently(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/users/team/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res) => userController.getUsersByTeamId(req, res));
// Team management routes
adminRouter.get("/teams", async (req, res, next) => {
    try {
        const teams = await teamRepository.getTeams();
        res.json(teams);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.delete("/teams/:teamId", async (req, res, next) => {
    try {
        const { teamId } = req.params;
        await teamRepository.deleteTeamById(teamId);
        res.json({ success: true, message: `Team with ID '${teamId}' deleted.` });
    }
    catch (error) {
        next(error);
    }
});
// ==============================================
// RESTAURANT MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createrestaurant", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => restaurantController.createRestaurant(req, res));
adminRouter.get("/restaurants", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res) => restaurantController.getRestaurants(req, res));
adminRouter.get("/getrestaurant/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await restaurantController.getRestaurantById(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.put("/updaterestaurant/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => restaurantController.updateRestaurant(req, res));
adminRouter.delete("/deleterestaurant/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => restaurantController.deleteRestaurant(req, res));
// ==============================================
// LEAD MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/leads", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    try {
        leadController.createLead(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/leads", (req, res, next) => {
    leadController.getLeads(req, res, next);
});
adminRouter.get("/leads/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res, next) => {
    leadController.getLeadById(req, res, next);
});
adminRouter.put("/leads/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    leadController.updateLead(req, res, next);
});
adminRouter.put("/leads/leadStatus/:id", // ✅ CORRECTED ROUTE
authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => {
    leadController.updateStatus(req, res);
});
adminRouter.put("/leads/leadStage/:id", // ✅ CORRECTED ROUTE
authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => {
    leadController.updateStage(req, res);
});
adminRouter.delete("/leads/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    leadController.deleteLead(req, res, next);
});
adminRouter.get("/leadsbytimeframe/:id", (req, res, next) => {
    console.log("Route hit, params:", req.params);
    leadController.getLeadsByTimeframe(req, res, next);
});
adminRouter.post('/assign-to-operations', async (req, res, next) => {
    try {
        await leadController.assignLeadToOperations(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.post('/assign-to-assessment', async (req, res, next) => {
    try {
        await leadController.assignLeadToAssessment(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get('/quotation-accepted', (req, res) => {
    console.log("route found");
    leadController.getQuotationAcceptedLeads(req, res);
});
// ==============================================
// PACKAGE MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/packages", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res, next) => packageController.createPackage(req, res, next));
adminRouter.post("/upload-image", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), multerConfig_1.packageUpload.single("image"), (req, res, next) => packageController.uploadImage(req, res, next));
adminRouter.put("/packages/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => packageController.updatePackage(req, res, next));
adminRouter.get("/packages", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res, next) => packageController.getPackages(req, res, next));
adminRouter.get("/packages/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res, next) => packageController.getPackageById(req, res, next));
adminRouter.delete("/packages/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => packageController.deletePackage(req, res, next));
// ==============================================
// QUOTATION MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createQuotations", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await quotationController.createQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/quotations", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), async (req, res) => {
    try {
        await quotationController.getQuotations(req, res);
    }
    catch (error) {
        console.log(error);
    }
});
adminRouter.get("/quotations/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), async (req, res) => {
    try {
        await quotationController.getQuotationById(req, res);
    }
    catch (error) {
        console.log(error);
    }
});
adminRouter.get('/quotation/:leadRefNo', authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), async (req, res, next) => {
    try {
        await quotationController.getQuotationByLeadRefNo(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.put("/quotations/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await quotationController.updateQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.delete("/quotations/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await quotationController.deleteQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.patch("/quotationStatus/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await quotationController.updateQuotationStatus(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/acceptedQuotation/:leadId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), async (req, res, next) => {
    try {
        await quotationController.getAcceptedQuotationsByLeadId(req, res);
    }
    catch (error) {
        next(error);
    }
});
// DOCUMENT ROUTES
adminRouter.post("/leads/:leadId/documents", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "agent", "user"]), multerConfig_1.documentUpload.single("document"), // Use documentUpload middleware
async (req, res, next) => {
    try {
        await documentController.uploadDocument(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/leads/:leadId/documents", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "agent", "user"]), async (req, res, next) => {
    try {
        await documentController.getDocumentsForLead(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.delete("/documents/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "agent", "user"]), async (req, res, next) => {
    try {
        await documentController.deleteDocument(req, res, next);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.post("/duplicateQuotation/:id", async (req, res, next) => {
    try {
        await quotationController.duplicateQuotation(req, res);
    }
    catch (error) {
        next(error);
    }
});
// ==============================================
adminRouter.get("/notification", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), notificationController_1.getAdminNotifications);
adminRouter.put("/markNotificationAsRead/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await (0, notificationController_1.markNotificationAsRead)(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.put("/markAllNotificationAsRead", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await (0, notificationController_1.markAllNotificationsAsRead)(req, res);
    }
    catch (error) {
        next(error);
    }
});
// ==============================================
// GUIDE MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createGuide", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), guideController.createGuide);
adminRouter.get("/guides", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), guideController.getGuides);
adminRouter.get("/getGuide/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), guideController.getGuideById);
adminRouter.put("/updateGuide/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), guideController.updateGuide);
adminRouter.delete("/deleteGuide/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), guideController.deleteGuide);
// ==============================================
// TOUR MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/tours", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res, next) => {
    tourController.createTour(req, res, next).catch(next); // Handle async errors
});
adminRouter.get("/tours", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user", "agent"]), (req, res, next) => {
    tourController.getTours(req, res, next).catch(next);
});
adminRouter.get("/tours/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res, next) => {
    tourController.getTourById(req, res, next).catch(next);
});
adminRouter.put("/tours/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    tourController.updateTour(req, res, next).catch(next);
});
adminRouter.delete("/tours/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res, next) => {
    tourController.deleteTour(req, res, next).catch(next);
});
exports.default = adminRouter;
// ==============================================
// BOOKING MANAGEMENT ROUTES
// ==============================================
adminRouter.post("/createBooking", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await bookingController.createBooking(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.get("/bookings", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res) => {
    try {
        await bookingController.getBookings(req, res);
    }
    catch (error) {
        console.log(error);
    }
});
adminRouter.get("/bookings/:id", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), async (req, res, next) => {
    try {
        await bookingController.getBookingById(req, res);
    }
    catch (error) {
        next(error);
    }
});
adminRouter.patch("/bookings/:id/status", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateBookingStatus(req, res);
});
adminRouter.patch("/bookings/:id/stage", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateBookingStage(req, res);
});
adminRouter.patch("/bookings/updateAccommodation/:bookingId/:accommodationId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateAccommodationHandler(req, res);
});
adminRouter.put('/bookings/updateItinerary/:bookingId/:itineraryId', authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => {
    bookingController.updateItinerary(req, res);
});
//----------------------------------------------
//final itinerary //
//----------------------------------------------
adminRouter.get("/bookings/:bookingId/final-itinerary", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => bookingController.getFinalItineraryItems(req, res));
adminRouter.post("/bookings/:bookingId/final-itinerary/generate-initial", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), 
// authenticateUser, authorizeRole(["admin", "user"]),
(req, res) => bookingController.generateInitialFinalItinerary(req, res));
adminRouter.post("/bookings/:bookingId/final-itinerary", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), 
// authenticateUser, authorizeRole(["admin", "user"]),
(req, res) => bookingController.createFinalItineraryItem(req, res));
adminRouter.put("/bookings/final-itinerary/:itemId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => bookingController.updateFinalItineraryItem(req, res));
adminRouter.delete("/bookings/final-itinerary/:itemId", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin", "user"]), (req, res) => bookingController.deleteFinalItineraryItem(req, res));
//# sourceMappingURL=adminRoutes.js.map