"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TourRepository = void 0;
const client_1 = require("@prisma/client");
const prisma = new client_1.PrismaClient();
class TourRepository {
    async getTours() {
        return await prisma.tour.findMany({
            include: {
                Suppliers: true,
                TourPrice: true,
            },
        });
    }
    async getTourById(id) {
        return await prisma.tour.findUnique({
            where: { id },
            include: {
                Suppliers: true,
                TourPrice: true,
            },
        });
    }
}
exports.TourRepository = TourRepository;
//# sourceMappingURL=userTourRepository.js.map