export declare class UserRepository {
    createUser(data: any): Promise<{
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }>;
    updateUser(id: string, data: any): Promise<{
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }>;
    private checkUniqueFields;
    private createConflictError;
    getUsers(): Promise<({
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    })[]>;
    getUserById(id: string): Promise<({
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }) | null>;
    getUserByEmail(email: string): Promise<({
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }) | null>;
    deleteUser(id: string): Promise<{
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }>;
    restore(id: string): Promise<{
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }>;
    deleteUserPermanently(id: string): Promise<{
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    }>;
    getInactiveUsers(): Promise<({
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    })[]>;
    getUsersByTeamId(teamId: string): Promise<({
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    })[]>;
    searchUsers(searchTerm: string): Promise<({
        team: {
            id: string;
            name: string;
        };
    } & {
        id: string;
        name: string;
        email: string;
        password: string;
        role: string | null;
        teamId: string;
        createdAt: Date;
        empCode: string;
        updatedAt: Date;
        mobile: string;
        empId: string;
        agentPrivilege: boolean;
        inactive: boolean | null;
    })[]>;
}
//# sourceMappingURL=userRepository.d.ts.map