"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserByEmail = void 0;
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
const getUserByEmail = async (email) => {
    if (!email) {
        throw new Error("Email is required to find the user");
    }
    return await prismaClient_1.default.user.findUnique({
        where: { email },
        include: { team: true }, // Fetch team details
    });
};
exports.getUserByEmail = getUserByEmail;
//# sourceMappingURL=userLoginRepository.js.map