import { Lead } from "../../interfaces/Lead";
import { LeadStage, LeadStatus } from "@prisma/client";
export declare class UserLeadRepository {
    private notificationService;
    constructor();
    private formatLeadDates;
    createLead(leadData: Lead): Promise<Lead>;
    getUserLeadsByUserId(userId: string): Promise<Lead[]>;
    getLeadById(leadId: string): Promise<Lead | null>;
    updateLead(leadId: string, leadData: Partial<Lead>): Promise<Lead | null>;
    deleteLead(leadId: string): Promise<void>;
    updateLeadStatus(id: string, status: LeadStatus): Promise<Lead | null>;
    updateLeadStage(id: string, newStage: LeadStage, userName?: string, notes?: string): Promise<Lead | null>;
}
//# sourceMappingURL=userLeadRepository.d.ts.map