"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuideRepository = void 0;
const client_1 = require("@prisma/client");
const prisma = new client_1.PrismaClient();
class GuideRepository {
    async getGuides() {
        return await prisma.guide.findMany({
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }
    async getGuideById(id) {
        return await prisma.guide.findUnique({
            where: { id },
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }
}
exports.GuideRepository = GuideRepository;
//# sourceMappingURL=userGuideRepository.js.map