export declare class OperationDashboardRepository {
    getDashboardData(userId: string): Promise<{
        totalBookings: number;
        totalQuotePrice: number;
        totalActualCost: number;
        totalProfit: number;
        latestBooking: ({
            lead: {
                id: string;
                email: string | null;
                userId: string | null;
                createdOn: Date;
                empCode: string | null;
                agentName: string | null;
                agentCode: string | null;
                leadNo: string;
                travelDateFrom: Date | null;
                travelDateTo: Date | null;
                totalPax: number | null;
                description: string | null;
                customerName: string | null;
                phone: string | null;
                adults: number | null;
                kids: number | null;
                infants: number | null;
                remarks: string | null;
                agentId: string | null;
                stage: import(".prisma/client").$Enums.LeadStage;
                status: import(".prisma/client").$Enums.LeadStatus;
                statusUpdated: Date | null;
                updatedAt: Date | null;
                assignedToId: string | null;
                assignedOperationId: string | null;
                assignedAssessmentId: string | null;
                assignedAssessmentOn: Date | null;
                assignedOperationOn: Date | null;
            } | null;
        } & {
            agent: string;
            id: string;
            createdAt: Date;
            leadNo: string | null;
            updatedAt: Date;
            termsAndConditions: string | null;
            guestName: string | null;
            currency: string | null;
            travelDates: string;
            currencyRate: number | null;
            importantNotes: string | null;
            reference: string;
            quotePrice: number;
            actualCost: number;
            actualPrice: number;
            profit: number;
            quotationId: string;
        }) | null;
        totalActualOverallPrice: number;
    }>;
    getTopBookingsByProfit(userId: string, limit?: number): Promise<{
        profit: number;
        id: string;
        lead: {
            id: string;
            agentName: string | null;
            assignedOperationId: string | null;
        } | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
    }[]>;
    getBookingLeadOverview(timeframe: string | undefined, userId: string): Promise<{
        date: string;
        leads: number;
        booked: number;
        cancelled: number;
    }[]>;
}
//# sourceMappingURL=operationDashboardRepository.d.ts.map