"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierRepository = void 0;
const prismaClient_1 = __importDefault(require("../config/prismaClient"));
const nanoid_1 = require("nanoid");
class SupplierRepository {
    createSupplier(data) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield prismaClient_1.default.suppliers.create({
                data: Object.assign({ id: (0, nanoid_1.nanoid)(12) }, data),
            });
        });
    }
    getSuppliers() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield prismaClient_1.default.suppliers.findMany();
        });
    }
    getSupplierById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield prismaClient_1.default.suppliers.findUnique({ where: { id } });
        });
    }
    updateSupplier(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield prismaClient_1.default.suppliers.update({ where: { id }, data });
        });
    }
    deleteSupplier(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield prismaClient_1.default.suppliers.delete({ where: { id } });
        });
    }
}
exports.SupplierRepository = SupplierRepository;
