"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttractionRepository = void 0;
const prismaClient_1 = __importDefault(require("../config/prismaClient"));
const nanoid_1 = require("nanoid");
class AttractionRepository {
    createAttraction(data) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const { prices, surchargeDates, closedDates } = data, attractionData = __rest(data, ["prices", "surchargeDates", "closedDates"]);
                const createdAttraction = yield prismaClient_1.default.attraction.create({
                    data: Object.assign(Object.assign({ id: (0, nanoid_1.nanoid)(24) }, attractionData), { surchargeDates: surchargeDates, closedDates: closedDates, prices: {
                            create: prices.map(price => ({
                                category: price.category,
                                paxType: price.paxType,
                                costPrice: price.costPrice,
                                optionalPrice: price.optionalPrice,
                            })),
                        } }),
                    include: {
                        prices: true,
                    },
                });
                return createdAttraction;
            }
            catch (error) {
                console.error("Error creating attraction in repository:", error);
                throw new Error(error.message || "Failed to create attraction");
            }
        });
    }
    getAttractions() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_1.default.attraction.findMany({
                    include: {
                        prices: true,
                    },
                });
            }
            catch (error) {
                console.error("Error fetching attractions:", error);
                throw new Error("Failed to fetch attractions");
            }
        });
    }
    getAttractionById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_1.default.attraction.findUnique({
                    where: { id },
                    include: {
                        prices: true,
                    },
                });
            }
            catch (error) {
                console.error(`Error fetching attraction with ID ${id}:`, error);
                throw new Error("Failed to fetch attraction");
            }
        });
    }
    updateAttraction(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const { prices, surchargeDates, closedDates } = data, attractionData = __rest(data, ["prices", "surchargeDates", "closedDates"]);
                // Delete existing prices
                yield prismaClient_1.default.attractionPrice.deleteMany({
                    where: {
                        attractionId: id,
                    },
                });
                const updatedAttraction = yield prismaClient_1.default.attraction.update({
                    where: { id },
                    data: Object.assign(Object.assign({}, attractionData), { surchargeDates: surchargeDates, closedDates: closedDates, prices: {
                            create: prices.map(price => ({
                                category: price.category,
                                paxType: price.paxType,
                                costPrice: price.costPrice,
                                optionalPrice: price.optionalPrice,
                            })),
                        } }),
                    include: {
                        prices: true,
                    },
                });
                return updatedAttraction;
            }
            catch (error) {
                console.error(`Error updating attraction with ID ${id}:`, error);
                throw new Error("Failed to update attraction");
            }
        });
    }
    deleteAttraction(id) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield prismaClient_1.default.attraction.delete({
                    where: { id },
                });
            }
            catch (error) {
                console.error(`Error deleting attraction with ID ${id}:`, error);
                throw new Error("Failed to delete attraction");
            }
        });
    }
}
exports.AttractionRepository = AttractionRepository;
