import { Agent, AgentCredentials } from "../../interfaces/Agent";
export declare class AgentRepository {
    getAgentByEmail(email: string): Promise<Agent | null>;
    getAgentByPhone(phone: string): Promise<Agent | null>;
    getAgentByAgentCode(agentCode: string): Promise<Agent | null>;
    createAgent(agentData: Agent, credentialsData?: AgentCredentials): Promise<Agent>;
    updateAgent(agentId: string, agentData: Partial<Agent>, credentialsData?: Partial<AgentCredentials>): Promise<Agent | null>;
    getAllAgents(): Promise<Agent[]>;
    deleteAgent(agentId: string): Promise<Agent | null>;
    softDeleteAgent(agentId: string): Promise<Agent | null>;
    restoreAgent(agentId: string): Promise<Agent | null>;
}
//# sourceMappingURL=agentRepository.d.ts.map