"use strict";
// backend/src/repositories/AgentLoginRepository.ts
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentLoginRepository = void 0;
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
class AgentLoginRepository {
    async getAgentByUsername(username) {
        if (!username) {
            console.warn("⚠️ getAgentByUsername called with null/empty username.");
            return null;
        }
        const normalizedUsername = username.trim().toLowerCase();
        try {
            const credentials = await prismaClient_1.default.agentCredentials.findFirst({
                where: { username: normalizedUsername },
                include: { agent: true },
            });
            console.log("📦 Agent credentials in repo:", credentials);
            if (!credentials) {
                console.log(`❌ No agent credentials found for username: ${normalizedUsername}`);
                return null;
            }
            if (!credentials.agent) {
                console.warn(`⚠️ Agent found but linked agent entity is null for username: ${normalizedUsername}`);
                // You can choose to return credentials here or null based on business logic
                // return null; // <-- uncomment this if agent being null is a hard error
            }
            return credentials;
        }
        catch (error) {
            console.error(`❗ Error fetching credentials by username ${normalizedUsername}:`, error);
            throw error;
        }
    }
}
exports.AgentLoginRepository = AgentLoginRepository;
//# sourceMappingURL=agentLoginRepository.js.map