import { QuotationStatus } from "@prisma/client";
import { Decimal } from "@prisma/client/runtime/library";
export declare class AgentQuotationRepository {
    getDuplicateRefNo(originalRefNo: string, existingRefNos: string[]): string;
    createQuotation(data: any, agentId: string): Promise<{
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Decimal | null;
                optionalPrice: Decimal | null;
                price: Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: Decimal | null;
            totalPriceAfterMarkup: Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Decimal | null;
                quantity: number | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: Decimal | null;
            itinMarkup: number | null;
        })[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
    duplicateQuotation(id: string, userName: string): Promise<{
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Decimal | null;
                optionalPrice: Decimal | null;
                price: Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: Decimal | null;
            totalPriceAfterMarkup: Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Decimal | null;
                quantity: number | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: Decimal | null;
            itinMarkup: number | null;
        })[];
        tours: {
            id: string;
            name: string;
            description: string | null;
            supplierId: string | null;
            location: string | null;
            termsAndConditions: string | null;
        }[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
    getQuotationById(id: string): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
        Agent: ({
            credentials: {
                id: string;
                password: string | null;
                username: string | null;
                filename: string | null;
            } | null;
        } & {
            id: string;
            email: string | null;
            role: string | null;
            createdAt: Date | null;
            agentCode: string | null;
            phone: string | null;
            updatedAt: Date | null;
            agentPrivilege: boolean | null;
            companyName: string | null;
            contactPerson: string | null;
            designation: string | null;
            companyAddress: string | null;
            deleted: boolean | null;
            state: string | null;
            markup: number | null;
            credentialsId: string | null;
        }) | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Decimal | null;
                optionalPrice: Decimal | null;
                price: Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: Decimal | null;
            totalPriceAfterMarkup: Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Decimal | null;
                quantity: number | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: Decimal | null;
            itinMarkup: number | null;
        })[];
        tours: {
            id: string;
            name: string;
            description: string | null;
            supplierId: string | null;
            location: string | null;
            termsAndConditions: string | null;
        }[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
    getAllQuotations(agentId: string): Promise<({
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
        Agent: ({
            credentials: {
                id: string;
                password: string | null;
                username: string | null;
                filename: string | null;
            } | null;
        } & {
            id: string;
            email: string | null;
            role: string | null;
            createdAt: Date | null;
            agentCode: string | null;
            phone: string | null;
            updatedAt: Date | null;
            agentPrivilege: boolean | null;
            companyName: string | null;
            contactPerson: string | null;
            designation: string | null;
            companyAddress: string | null;
            deleted: boolean | null;
            state: string | null;
            markup: number | null;
            credentialsId: string | null;
        }) | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Decimal | null;
                optionalPrice: Decimal | null;
                price: Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: Decimal | null;
            totalPriceAfterMarkup: Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Decimal | null;
                quantity: number | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: Decimal | null;
            itinMarkup: number | null;
        })[];
        tours: {
            id: string;
            name: string;
            description: string | null;
            supplierId: string | null;
            location: string | null;
            termsAndConditions: string | null;
        }[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    })[]>;
    updateQuotation(id: string, data: any): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Decimal | null;
                optionalPrice: Decimal | null;
                price: Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: Decimal | null;
            totalPriceAfterMarkup: Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Decimal | null;
                quantity: number | null;
                totalPrice: Decimal | null;
                totalPriceAfterMarkup: Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: Decimal | null;
            itinMarkup: number | null;
        })[];
        tours: {
            id: string;
            name: string;
            description: string | null;
            supplierId: string | null;
            location: string | null;
            termsAndConditions: string | null;
        }[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
    deleteQuotation(id: string): Promise<{
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
    updateQuotationStatus(id: string, status: QuotationStatus, userName: string): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Decimal | null;
        totalBeforeMarkup: Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
}
//# sourceMappingURL=AgentQuotationRepository.d.ts.map