import { LeadStage, LeadStatus } from "@prisma/client";
import { Lead } from "../../interfaces/Lead";
export declare class AgentLeadRepository {
    private notificationService;
    constructor();
    private formatLeadDates;
    createLead(leadData: Lead): Promise<Lead>;
    getAgentLeads(agentId: string): Promise<Lead[]>;
    getLeadById(leadId: string, agentId: string): Promise<Lead | null>;
    updateLead(leadId: string, agentId: string, leadData: Partial<Lead>): Promise<Lead | null>;
    deleteLead(leadId: string, agentId: string): Promise<void>;
    updateLeadStatus(id: string, status: LeadStatus): Promise<Lead | null>;
    updateLeadStage(id: string, newStage: LeadStage, userName?: string, notes?: string): Promise<Lead | null>;
}
//# sourceMappingURL=AgentLeadRepository.d.ts.map