interface TourPriceInput {
    minNoOfPax: number | null;
    maxNoOfPax: number | null;
    paxType: string;
    costPrice: number | null;
    optionalPrice?: string | null;
    vehicle?: string;
    id?: string;
    _destroy?: boolean;
}
interface CreateTourInput {
    name: string;
    location: string;
    description: string;
    termsAndConditions: string;
    supplierId: string;
    TourPrice: TourPriceInput[];
}
export declare class TourRepository {
    createTour(data: CreateTourInput): Promise<{
        TourPrice: {
            id: string;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: string | null;
            vehicle: string | null;
            minNoOfPax: number | null;
            maxNoOfPax: number | null;
            tourId: string;
        }[];
    } & {
        id: string;
        name: string;
        description: string | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
    }>;
    getTours(): Promise<({
        Suppliers: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        TourPrice: {
            id: string;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: string | null;
            vehicle: string | null;
            minNoOfPax: number | null;
            maxNoOfPax: number | null;
            tourId: string;
        }[];
    } & {
        id: string;
        name: string;
        description: string | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
    })[]>;
    getTourById(id: string): Promise<({
        Suppliers: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        TourPrice: {
            id: string;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: string | null;
            vehicle: string | null;
            minNoOfPax: number | null;
            maxNoOfPax: number | null;
            tourId: string;
        }[];
    } & {
        id: string;
        name: string;
        description: string | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
    }) | null>;
    updateTour(id: string, data: CreateTourInput & {
        TourPrice: TourPriceInput[];
    }): Promise<({
        Suppliers: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        TourPrice: {
            id: string;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: string | null;
            vehicle: string | null;
            minNoOfPax: number | null;
            maxNoOfPax: number | null;
            tourId: string;
        }[];
    } & {
        id: string;
        name: string;
        description: string | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
    }) | null>;
    deleteTour(id: string): Promise<{
        TourPrice: {
            id: string;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: string | null;
            vehicle: string | null;
            minNoOfPax: number | null;
            maxNoOfPax: number | null;
            tourId: string;
        }[];
    } & {
        id: string;
        name: string;
        description: string | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
    }>;
}
export {};
//# sourceMappingURL=tourRepository.d.ts.map