"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeamRepository = void 0;
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
class TeamRepository {
    async createDefaultTeams() {
        const defaultTeams = ["lead", "operation", "assessment", "finance"];
        for (const teamName of defaultTeams) {
            // Check if the team already exists
            const existingTeam = await prismaClient_1.default.team.findUnique({
                where: { name: teamName },
            });
            if (!existingTeam) {
                // Create the team if it doesn't exist
                await prismaClient_1.default.team.create({
                    data: { name: teamName },
                });
                console.log(`Team '${teamName}' created.`);
            }
        }
        console.log("All default teams are set up.");
    }
    async getTeams() {
        return await prismaClient_1.default.team.findMany();
    }
    async deleteTeamById(teamId) {
        try {
            await prismaClient_1.default.team.delete({
                where: { id: teamId },
            });
            console.log(`Team with ID '${teamId}' deleted.`);
        }
        catch (error) {
            console.error(`Error deleting team with ID '${teamId}':`, error);
            throw new Error("Team not found or cannot be deleted.");
        }
    }
}
exports.TeamRepository = TeamRepository;
//# sourceMappingURL=teamRepository.js.map