"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierRepository = void 0;
const nanoid_1 = require("nanoid");
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
class SupplierRepository {
    async createSupplier(data) {
        return await prismaClient_1.default.suppliers.create({
            data: { id: (0, nanoid_1.nanoid)(24), ...data },
        });
    }
    async getSuppliers() {
        return await prismaClient_1.default.suppliers.findMany();
    }
    async getSupplierById(id) {
        return await prismaClient_1.default.suppliers.findUnique({ where: { id } });
    }
    async updateSupplier(id, data) {
        return await prismaClient_1.default.suppliers.update({ where: { id }, data });
    }
    async deleteSupplier(id) {
        return await prismaClient_1.default.suppliers.delete({ where: { id } });
    }
}
exports.SupplierRepository = SupplierRepository;
//# sourceMappingURL=supplierRepository.js.map