import { RestaurantData } from "interfaces/Restaurant";
export declare class RestaurantRepository {
    createRestaurant(data: RestaurantData): Promise<{
        mealPrices: {
            id: string;
            category: string | null;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string | null;
            restaurantId: string | null;
        }[];
    } & {
        id: string;
        name: string | null;
        description: string;
        updatedAt: Date | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
        targetMarket: string | null;
    }>;
    getRestaurants(): Promise<({
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        mealPrices: {
            id: string;
            category: string | null;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string | null;
            restaurantId: string | null;
        }[];
    } & {
        id: string;
        name: string | null;
        description: string;
        updatedAt: Date | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
        targetMarket: string | null;
    })[]>;
    getRestaurantById(id: string): Promise<({
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        mealPrices: {
            id: string;
            category: string | null;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string | null;
            restaurantId: string | null;
        }[];
    } & {
        id: string;
        name: string | null;
        description: string;
        updatedAt: Date | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
        targetMarket: string | null;
    }) | null>;
    updateRestaurant(id: string, data: RestaurantData): Promise<{
        mealPrices: {
            id: string;
            category: string | null;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string | null;
            restaurantId: string | null;
        }[];
    } & {
        id: string;
        name: string | null;
        description: string;
        updatedAt: Date | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
        targetMarket: string | null;
    }>;
    deleteRestaurant(id: string): Promise<{
        id: string;
        name: string | null;
        description: string;
        updatedAt: Date | null;
        supplierId: string | null;
        location: string | null;
        termsAndConditions: string | null;
        targetMarket: string | null;
    }>;
}
//# sourceMappingURL=restaurantrepository.d.ts.map