"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageRepository = void 0;
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
class PackageRepository {
    // backend/src/repositories/packageRepository.ts
    async createPackage(packageData) {
        try {
            const newPackage = await prismaClient_1.default.package.create({
                data: {
                    packageName: packageData.packageName,
                    tagLine: packageData.tagLine,
                    briefDescription: packageData.briefDescription,
                    detailedDescription: packageData.detailedDescription,
                    terms: packageData.terms,
                    notes: packageData.notes,
                    remarks: packageData.remarks,
                    imageUrl: packageData.imageUrl,
                    starRating: packageData.starRating,
                    price: packageData.price,
                    hotel: packageData.hotel,
                    daysNights: packageData.daysNights,
                    members: packageData.members,
                    deleted: packageData.deleted,
                    hotelId: packageData.hotelId,
                }
            });
            return newPackage;
        }
        catch (error) {
            console.error("Error creating package in repository:", error);
            throw error;
        }
    }
    async updatePackage(packageId, packageData) {
        try {
            const updatedPackage = await prismaClient_1.default.package.update({
                where: { id: parseInt(packageId) },
                data: {
                    packageName: packageData.packageName,
                    tagLine: packageData.tagLine,
                    briefDescription: packageData.briefDescription,
                    detailedDescription: packageData.detailedDescription,
                    terms: packageData.terms,
                    notes: packageData.notes,
                    remarks: packageData.remarks,
                    imageUrl: packageData.imageUrl,
                    starRating: packageData.starRating,
                    price: packageData.price,
                    hotel: packageData.hotel,
                    daysNights: packageData.daysNights,
                    members: packageData.members,
                    deleted: packageData.deleted,
                    hotelId: packageData.hotelId,
                },
            });
            return updatedPackage;
        }
        catch (error) {
            console.error("Error updating package in repository:", error);
            throw error;
        }
    }
    async getAllPackages() {
        try {
            const packages = await prismaClient_1.default.package.findMany();
            return packages;
        }
        catch (error) {
            console.error("Error getting packages in repository:", error);
            throw error;
        }
    }
    async getPackageById(packageId) {
        try {
            const packageItem = await prismaClient_1.default.package.findUnique({
                where: { id: parseInt(packageId) },
            });
            return packageItem;
        }
        catch (error) {
            console.error("Error getting package by ID in repository:", error);
            throw error;
        }
    }
    async deletePackage(packageId) {
        try {
            await prismaClient_1.default.package.delete({
                where: { id: parseInt(packageId) },
            });
        }
        catch (error) {
            console.error("Error deleting package in repository:", error);
            throw error;
        }
    }
}
exports.PackageRepository = PackageRepository;
//# sourceMappingURL=packageRepository.js.map