import { Omit } from "utility-types";
import { Package } from "../../interfaces/Package";
export declare class PackageRepository {
    createPackage(packageData: Omit<Package, "id">): Promise<Package>;
    updatePackage(packageId: string, packageData: Partial<Package>): Promise<Package>;
    getAllPackages(): Promise<Package[]>;
    getPackageById(packageId: string): Promise<Package | null>;
    deletePackage(packageId: string): Promise<void>;
}
//# sourceMappingURL=packageRepository.d.ts.map