import { Lead } from "../../interfaces/Lead";
import { LeadStage, LeadStatus } from "@prisma/client";
export declare class LeadRepository {
    private notificationService;
    private bookingRepository;
    constructor();
    private formatLeadDates;
    createLead(leadData: Lead, userName: string): Promise<Lead>;
    getAllLeads(): Promise<Lead[]>;
    getLeadById(leadId: string): Promise<Lead | null>;
    updateLead(leadId: string, leadData: Partial<Lead>): Promise<Lead | null>;
    deleteLead(leadId: string): Promise<void>;
    getLeadsByTimeframe(timeframe: string): Promise<any[]>;
    private formatLeadsByTimeframe;
    updateLeadStatus(id: string, status: LeadStatus): Promise<Lead | null>;
    updateLeadStage(id: string, newStage: LeadStage, userName?: string, notes?: string): Promise<Lead | null>;
    assignLeadToOperations(leadId: string, operationUserId: string): Promise<{
        id: string;
        email: string | null;
        userId: string | null;
        createdOn: Date;
        empCode: string | null;
        agentName: string | null;
        agentCode: string | null;
        leadNo: string;
        travelDateFrom: Date | null;
        travelDateTo: Date | null;
        totalPax: number | null;
        description: string | null;
        customerName: string | null;
        phone: string | null;
        adults: number | null;
        kids: number | null;
        infants: number | null;
        remarks: string | null;
        agentId: string | null;
        stage: import(".prisma/client").$Enums.LeadStage;
        status: import(".prisma/client").$Enums.LeadStatus;
        statusUpdated: Date | null;
        updatedAt: Date | null;
        assignedToId: string | null;
        assignedOperationId: string | null;
        assignedAssessmentId: string | null;
        assignedAssessmentOn: Date | null;
        assignedOperationOn: Date | null;
    }>;
    assignLeadToAssessment(leadId: string, assessmentUserId: string): Promise<{
        id: string;
        email: string | null;
        userId: string | null;
        createdOn: Date;
        empCode: string | null;
        agentName: string | null;
        agentCode: string | null;
        leadNo: string;
        travelDateFrom: Date | null;
        travelDateTo: Date | null;
        totalPax: number | null;
        description: string | null;
        customerName: string | null;
        phone: string | null;
        adults: number | null;
        kids: number | null;
        infants: number | null;
        remarks: string | null;
        agentId: string | null;
        stage: import(".prisma/client").$Enums.LeadStage;
        status: import(".prisma/client").$Enums.LeadStatus;
        statusUpdated: Date | null;
        updatedAt: Date | null;
        assignedToId: string | null;
        assignedOperationId: string | null;
        assignedAssessmentId: string | null;
        assignedAssessmentOn: Date | null;
        assignedOperationOn: Date | null;
    }>;
    findQuotationAcceptedLeads(): Promise<({
        Agent: {
            id: string;
            email: string | null;
            role: string | null;
            createdAt: Date | null;
            agentCode: string | null;
            phone: string | null;
            updatedAt: Date | null;
            agentPrivilege: boolean | null;
            companyName: string | null;
            contactPerson: string | null;
            designation: string | null;
            companyAddress: string | null;
            deleted: boolean | null;
            state: string | null;
            markup: number | null;
            credentialsId: string | null;
        } | null;
        Quotation: ({
            accommodations: ({
                priceDetailsAccommodation: {
                    id: string;
                    category: string | null;
                    costPrice: import("@prisma/client/runtime/library").Decimal | null;
                    optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                    price: import("@prisma/client/runtime/library").Decimal | null;
                    pax: string | null;
                    quantity: number | null;
                    accommodationId: string | null;
                    roomId: string | null;
                    totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                    totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                    priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                }[];
            } & {
                id: string;
                createdAt: Date;
                updatedAt: Date;
                supplierId: string | null;
                hotel: string | null;
                room: string | null;
                quotationId: string;
                quantity: number | null;
                endDate: Date | null;
                nights: number | null;
                priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
                surchargeNights: number | null;
                travelDate: Date | null;
                supplierContact: string | null;
                supplierName: string | null;
                hotelAddress: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                accMarkup: number | null;
            })[];
            itineraries: ({
                priceDetailsList: {
                    id: string;
                    category: string | null;
                    price: import("@prisma/client/runtime/library").Decimal | null;
                    quantity: number | null;
                    totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                    totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                    itineraryId: string | null;
                    priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                }[];
            } & {
                id: string;
                supplierId: string | null;
                category: string | null;
                quotationId: string;
                priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
                supplierContact: string | null;
                supplierName: string | null;
                date: Date | null;
                label: string | null;
                guideId: string | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itinMarkup: number | null;
            })[];
        } & {
            id: string;
            totalPax: number | null;
            remarks: string | null;
            agentId: string | null;
            status: import(".prisma/client").$Enums.QuotationStatus;
            updatedAt: Date;
            termsAndConditions: string | null;
            refNo: string;
            leadAgent: string;
            guestName: string | null;
            currency: string | null;
            travelDates: string;
            leadRefNo: string;
            totalAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            totalBeforeMarkup: import("@prisma/client/runtime/library").Decimal | null;
            userid: string | null;
            currencyRate: number | null;
            importantNotes: string | null;
        })[];
    } & {
        id: string;
        email: string | null;
        userId: string | null;
        createdOn: Date;
        empCode: string | null;
        agentName: string | null;
        agentCode: string | null;
        leadNo: string;
        travelDateFrom: Date | null;
        travelDateTo: Date | null;
        totalPax: number | null;
        description: string | null;
        customerName: string | null;
        phone: string | null;
        adults: number | null;
        kids: number | null;
        infants: number | null;
        remarks: string | null;
        agentId: string | null;
        stage: import(".prisma/client").$Enums.LeadStage;
        status: import(".prisma/client").$Enums.LeadStatus;
        statusUpdated: Date | null;
        updatedAt: Date | null;
        assignedToId: string | null;
        assignedOperationId: string | null;
        assignedAssessmentId: string | null;
        assignedAssessmentOn: Date | null;
        assignedOperationOn: Date | null;
    })[]>;
}
//# sourceMappingURL=leadRepository.d.ts.map