import { Hotel } from "../../interfaces/Hotel";
export declare class HotelRepository {
    createHotel(data: Hotel): Promise<{
        id: string;
        name: string;
        createdAt: Date;
        description: string | null;
        phone: string | null;
        updatedAt: Date | null;
        closedDates: import("@prisma/client/runtime/library").JsonValue | null;
        supplierId: string | null;
        location: string | null;
        starRating: string | null;
        tourismTax: string | null;
        stateTax: string | null;
        address: string | null;
        termsAndConditions: string | null;
        surcharge: import("@prisma/client/runtime/library").JsonValue | null;
    }>;
    getHotels(page?: number, limit?: number, searchTerm?: string): Promise<{
        hotels: ({
            supplier: {
                id: string;
                companyName: string | null;
            } | null;
            price: {
                id: string;
                category: string | null;
                costPrice: number | null;
                optionalPrice: number | null;
                pax: string | null;
                hotelId: string;
            }[];
            rooms: {
                id: string;
                name: string;
                hotelId: string;
                maxPax: number | null;
                extraBeds: number | null;
            }[];
        } & {
            id: string;
            name: string;
            createdAt: Date;
            description: string | null;
            phone: string | null;
            updatedAt: Date | null;
            closedDates: import("@prisma/client/runtime/library").JsonValue | null;
            supplierId: string | null;
            location: string | null;
            starRating: string | null;
            tourismTax: string | null;
            stateTax: string | null;
            address: string | null;
            termsAndConditions: string | null;
            surcharge: import("@prisma/client/runtime/library").JsonValue | null;
        })[];
        currentPage: number;
        totalPages: number;
        totalItems: number;
    }>;
    getHotelById(id: string): Promise<({
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
        price: {
            id: string;
            category: string | null;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string | null;
            hotelId: string;
        }[];
        rooms: {
            id: string;
            name: string;
            hotelId: string;
            maxPax: number | null;
            extraBeds: number | null;
        }[];
    } & {
        id: string;
        name: string;
        createdAt: Date;
        description: string | null;
        phone: string | null;
        updatedAt: Date | null;
        closedDates: import("@prisma/client/runtime/library").JsonValue | null;
        supplierId: string | null;
        location: string | null;
        starRating: string | null;
        tourismTax: string | null;
        stateTax: string | null;
        address: string | null;
        termsAndConditions: string | null;
        surcharge: import("@prisma/client/runtime/library").JsonValue | null;
    }) | null>;
    updateHotel(id: string, data: Hotel): Promise<{
        id: string;
        name: string;
        createdAt: Date;
        description: string | null;
        phone: string | null;
        updatedAt: Date | null;
        closedDates: import("@prisma/client/runtime/library").JsonValue | null;
        supplierId: string | null;
        location: string | null;
        starRating: string | null;
        tourismTax: string | null;
        stateTax: string | null;
        address: string | null;
        termsAndConditions: string | null;
        surcharge: import("@prisma/client/runtime/library").JsonValue | null;
    }>;
    deleteHotel(id: string): Promise<{
        id: string;
        name: string;
        createdAt: Date;
        description: string | null;
        phone: string | null;
        updatedAt: Date | null;
        closedDates: import("@prisma/client/runtime/library").JsonValue | null;
        supplierId: string | null;
        location: string | null;
        starRating: string | null;
        tourismTax: string | null;
        stateTax: string | null;
        address: string | null;
        termsAndConditions: string | null;
        surcharge: import("@prisma/client/runtime/library").JsonValue | null;
    }>;
    createRoom(data: any): Promise<{
        prices: {
            id: string;
            category: string;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string;
            roomId: string;
        }[];
        hotel: {
            id: string;
            name: string;
            createdAt: Date;
            description: string | null;
            phone: string | null;
            updatedAt: Date | null;
            closedDates: import("@prisma/client/runtime/library").JsonValue | null;
            supplierId: string | null;
            location: string | null;
            starRating: string | null;
            tourismTax: string | null;
            stateTax: string | null;
            address: string | null;
            termsAndConditions: string | null;
            surcharge: import("@prisma/client/runtime/library").JsonValue | null;
        };
    } & {
        id: string;
        name: string;
        hotelId: string;
        maxPax: number | null;
        extraBeds: number | null;
    }>;
    updateRoom(id: string, data: any): Promise<{
        prices: {
            id: string;
            category: string;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string;
            roomId: string;
        }[];
        hotel: {
            id: string;
            name: string;
            createdAt: Date;
            description: string | null;
            phone: string | null;
            updatedAt: Date | null;
            closedDates: import("@prisma/client/runtime/library").JsonValue | null;
            supplierId: string | null;
            location: string | null;
            starRating: string | null;
            tourismTax: string | null;
            stateTax: string | null;
            address: string | null;
            termsAndConditions: string | null;
            surcharge: import("@prisma/client/runtime/library").JsonValue | null;
        };
    } & {
        id: string;
        name: string;
        hotelId: string;
        maxPax: number | null;
        extraBeds: number | null;
    }>;
    deleteRoom(id: string): Promise<{
        id: string;
        name: string;
        hotelId: string;
        maxPax: number | null;
        extraBeds: number | null;
    }>;
    getRoomById(id: string): Promise<({
        prices: {
            id: string;
            category: string;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string;
            roomId: string;
        }[];
        hotel: {
            id: string;
            name: string;
            createdAt: Date;
            description: string | null;
            phone: string | null;
            updatedAt: Date | null;
            closedDates: import("@prisma/client/runtime/library").JsonValue | null;
            supplierId: string | null;
            location: string | null;
            starRating: string | null;
            tourismTax: string | null;
            stateTax: string | null;
            address: string | null;
            termsAndConditions: string | null;
            surcharge: import("@prisma/client/runtime/library").JsonValue | null;
        };
    } & {
        id: string;
        name: string;
        hotelId: string;
        maxPax: number | null;
        extraBeds: number | null;
    }) | null>;
    getRoomsByHotelId(hotelId: string): Promise<({
        prices: {
            id: string;
            category: string;
            costPrice: number | null;
            optionalPrice: number | null;
            pax: string;
            roomId: string;
        }[];
        hotel: {
            id: string;
            name: string;
            createdAt: Date;
            description: string | null;
            phone: string | null;
            updatedAt: Date | null;
            closedDates: import("@prisma/client/runtime/library").JsonValue | null;
            supplierId: string | null;
            location: string | null;
            starRating: string | null;
            tourismTax: string | null;
            stateTax: string | null;
            address: string | null;
            termsAndConditions: string | null;
            surcharge: import("@prisma/client/runtime/library").JsonValue | null;
        };
    } & {
        id: string;
        name: string;
        hotelId: string;
        maxPax: number | null;
        extraBeds: number | null;
    })[]>;
}
//# sourceMappingURL=hotelRepository.d.ts.map