"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuideRepository = void 0;
// server/src/repositories/admin/guideRepository.ts
const client_1 = require("@prisma/client");
const nanoid_1 = require("nanoid");
const prisma = new client_1.PrismaClient();
class GuideRepository {
    async createGuide(data) {
        return await prisma.guide.create({
            data: {
                id: (0, nanoid_1.nanoid)(24),
                name: data.name,
                phone: data.phone,
                email: data.email,
                description: data.description,
                termsAndConditions: data.termsAndConditions,
                supplierId: data.supplierId,
                GuidePrice: {
                    create: data.GuidePrice.map((price) => ({
                        id: (0, nanoid_1.nanoid)(24),
                        costPrice: price.costPrice,
                        optionalPrice: price.optionalPrice,
                        paxType: price.paxType,
                        category: price.category
                    })),
                },
            },
            include: {
                GuidePrice: true,
            },
        });
    }
    async getGuides() {
        return await prisma.guide.findMany({
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }
    async getGuideById(id) {
        return await prisma.guide.findUnique({
            where: { id },
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }
    async updateGuide(id, data) {
        // Step 1: Delete old prices
        await prisma.guidePrice.deleteMany({
            where: { guideId: id },
        });
        // Step 2: Update guide basic info and recreate prices
        return await prisma.guide.update({
            where: { id },
            data: {
                name: data.name,
                phone: data.phone,
                email: data.email,
                description: data.description,
                termsAndConditions: data.termsAndConditions,
                supplierId: data.supplierId,
                GuidePrice: {
                    create: data.GuidePrice.map((price) => ({
                        id: (0, nanoid_1.nanoid)(24),
                        costPrice: price.costPrice,
                        optionalPrice: price.optionalPrice,
                        paxType: price.paxType,
                        category: price.category
                    })),
                },
            },
            include: {
                GuidePrice: true,
            },
        });
    }
    async deleteGuide(id) {
        return await prisma.guide.delete({
            where: { id },
            include: {
                GuidePrice: true,
            },
        });
    }
}
exports.GuideRepository = GuideRepository;
//# sourceMappingURL=guideRepository.js.map