"use strict";
// backend/src/repositories/admin/documentRepository.ts
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentRepository = void 0;
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
class DocumentRepository {
    async createDocument(documentData) {
        try {
            const newDocument = await prismaClient_1.default.document.create({
                data: {
                    ...documentData,
                    updatedAt: new Date().toISOString(), // Ensure updatedAt is provided
                },
            });
            return newDocument;
        }
        catch (error) {
            console.error('Error creating document in repository:', error);
            throw error;
        }
    }
    async getDocumentsForLead(leadId) {
        try {
            const documents = await prismaClient_1.default.document.findMany({
                where: {
                    leadId: leadId,
                },
            });
            return documents;
        }
        catch (error) {
            console.error('Error getting documents for lead in repository:', error);
            throw error;
        }
    }
    async deleteDocument(documentId) {
        try {
            await prismaClient_1.default.document.delete({
                where: {
                    id: documentId,
                },
            });
        }
        catch (error) {
            console.error('Error deleting document in repository:', error);
            throw error;
        }
    }
}
exports.DocumentRepository = DocumentRepository;
//# sourceMappingURL=documentRepository.js.map