export declare class DashboardRepository {
    getCountsPerDay(tableName: 'user' | 'agent' | 'lead', n?: number): Promise<any[]>;
    getDashboardData(): Promise<{
        totalLeads: number;
        bookedLeads: number;
        newLeads: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        }[];
        userCount: number;
        agentCount: number;
        dataSeries: {
            users: any[];
            agents: any[];
            leads: any[];
            bookings: number[];
        };
    }>;
    getLeadStageCounts(period?: 'all' | '30d' | '90d'): Promise<{
        new_lead?: number | undefined;
        quotation_created?: number | undefined;
        quotation_sent?: number | undefined;
        quotation_accepted?: number | undefined;
        quotation_revised?: number | undefined;
        assigned_to_operations?: number | undefined;
        advance_payment?: number | undefined;
        hotel_booked?: number | undefined;
        flight_booked?: number | undefined;
        itinerary_finalized?: number | undefined;
        docs_shared?: number | undefined;
        final_payment?: number | undefined;
        trip_started?: number | undefined;
        trip_completed?: number | undefined;
        feedback_collected?: number | undefined;
        canceled?: number | undefined;
        quotation_duplicated?: number | undefined;
        assigned_to_assessment?: number | undefined;
    }>;
    getTopAgentsByLeadCount(limit?: number): Promise<(import(".prisma/client").Prisma.PickEnumerable<import(".prisma/client").Prisma.LeadGroupByOutputType, ("agentName" | "agentCode")[]> & {
        _count: {
            agentCode: number;
        };
    })[]>;
    getTopSalesByLeadCount(limit?: number): Promise<{
        userId: string;
        salesPersonName: string;
        empCode: string;
        leadCount: number;
    }[]>;
}
//# sourceMappingURL=dashboardRepository.d.ts.map