import { FinalItineraryItem, Prisma } from "@prisma/client";
type BookingWithFullDetails = Prisma.BookingGetPayload<{
    include: {
        hotelVouchers: true;
        accommodations: {
            include: {
                priceDetailsAccommodation: true;
            };
        };
        itineraries: {
            include: {
                priceDetailsList: true;
            };
        };
        lead: {
            include: {
                Agent: true;
            };
        };
    };
}>;
type BookingAccommodationUpdateData = {
    hotel?: string;
    room?: string;
    supplierName?: string;
    supplierContact?: string;
    travelDate?: string;
    nights?: number;
    quotePrice?: number | null;
    actualPrice?: number | null;
    confirmationNo?: string;
    details?: string;
    quantity?: number;
    priceDetailsAccommodation?: Prisma.BookingPriceDetailsAccommodationCreateManyAccommodationInput[];
};
export declare class BookingRepository {
    fetchQuotationWithDetails(quotationId: string): Promise<({
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
        Agent: {
            id: string;
            email: string | null;
            role: string | null;
            createdAt: Date | null;
            agentCode: string | null;
            phone: string | null;
            updatedAt: Date | null;
            agentPrivilege: boolean | null;
            companyName: string | null;
            contactPerson: string | null;
            designation: string | null;
            companyAddress: string | null;
            deleted: boolean | null;
            state: string | null;
            markup: number | null;
            credentialsId: string | null;
        } | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Prisma.Decimal | null;
                optionalPrice: Prisma.Decimal | null;
                price: Prisma.Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
                priceAfterMarkup: Prisma.Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: Prisma.JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: Prisma.Decimal | null;
            totalPriceAfterMarkup: Prisma.Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Prisma.Decimal | null;
                quantity: number | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: Prisma.Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: Prisma.JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: Prisma.Decimal | null;
            itinMarkup: number | null;
        })[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: Prisma.Decimal | null;
        totalBeforeMarkup: Prisma.Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }) | null>;
    handleCreateBooking(quotation: any): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        } | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Prisma.Decimal | null;
                optionalPrice: Prisma.Decimal | null;
                price: Prisma.Decimal | null;
                pax: string | null;
                quotePrice: Prisma.Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: Prisma.Decimal | null;
            actualPrice: Prisma.Decimal | null;
            profit: Prisma.Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: Prisma.JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Prisma.Decimal | null;
                quotePrice: Prisma.Decimal | null;
                quantity: number | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
                itineraryId: string | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotePrice: Prisma.Decimal | null;
            actualPrice: Prisma.Decimal | null;
            profit: Prisma.Decimal | null;
            quotationId: string;
            priceDetails: Prisma.JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            bookingId: string | null;
        })[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    }>;
    getAllBookings(): Promise<({
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        } | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Prisma.Decimal | null;
                optionalPrice: Prisma.Decimal | null;
                price: Prisma.Decimal | null;
                pax: string | null;
                quotePrice: Prisma.Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: Prisma.Decimal | null;
            actualPrice: Prisma.Decimal | null;
            profit: Prisma.Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: Prisma.JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: Prisma.Decimal | null;
                quotePrice: Prisma.Decimal | null;
                quantity: number | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
                itineraryId: string | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotePrice: Prisma.Decimal | null;
            actualPrice: Prisma.Decimal | null;
            profit: Prisma.Decimal | null;
            quotationId: string;
            priceDetails: Prisma.JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            bookingId: string | null;
        })[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    })[]>;
    getBookingById(id: string): Promise<BookingWithFullDetails | null>;
    findBookingWithAccommodations(bookingId: string): Promise<({
        accommodations: {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: Prisma.Decimal | null;
            actualPrice: Prisma.Decimal | null;
            profit: Prisma.Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: Prisma.JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        }[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    }) | null>;
    updateAccommodation(accommodationId: string, updateData: BookingAccommodationUpdateData): Promise<{
        updatedAccommodation: {
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: Prisma.Decimal | null;
                optionalPrice: Prisma.Decimal | null;
                price: Prisma.Decimal | null;
                pax: string | null;
                quotePrice: Prisma.Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: Prisma.Decimal | null;
                totalPriceAfterMarkup: Prisma.Decimal | null;
            }[];
            booking: {
                id: string;
                lead: {
                    totalPax: number | null;
                    customerName: string | null;
                    adults: number | null;
                    kids: number | null;
                } | null;
                leadNo: string | null;
                reference: string;
            } | null;
            hotelVoucher: {
                id: string;
                customerName: string | null;
                termsAndConditions: string | null;
                hotelAddress: string | null;
                accommodationId: string;
                bookingId: string | null;
                voucherNo: string;
                totalAdults: number | null;
                totalKids: number | null;
                hotelName: string;
                hotelPhone: string | null;
                checkInDate: Date;
                checkOutDate: Date;
                roomDetails: string;
                mealPlan: string | null;
                confirmationNumber: string | null;
                specialInclusions: string | null;
                issuedAt: Date;
            } | null;
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: Prisma.Decimal | null;
            actualPrice: Prisma.Decimal | null;
            profit: Prisma.Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: Prisma.JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        };
        voucher: {
            id: string;
            voucherNumber: string;
            type: "Hotel";
            serviceName: string;
            customerName: string;
            totalAdults: number;
            totalKids: number;
            hotelAddress: string;
            hotelPhone: string;
            confirmationNumber: string;
            checkInDate: string;
            checkOutDate: string;
            nights: number;
            roomDetailsDescription: string;
            mealPlan: string;
            specialInclusions: string;
            status: "Confirmed";
        };
    }>;
    updateItinerary(itineraryId: string, updateData: {
        date?: string;
        label?: string;
        category?: string;
        supplierId?: string;
        supplierName?: string;
        supplierContact?: string;
        quotePrice?: number | null;
        actualPrice?: number | null;
        confirmationNo?: string;
        details?: string;
        priceDetailsList?: Prisma.BookingPriceDetailItineraryCreateManyItineraryInput[];
    }): Promise<({
        priceDetailsList: {
            id: string;
            category: string | null;
            price: Prisma.Decimal | null;
            quotePrice: Prisma.Decimal | null;
            quantity: number | null;
            totalPrice: Prisma.Decimal | null;
            totalPriceAfterMarkup: Prisma.Decimal | null;
            itineraryId: string | null;
        }[];
    } & {
        id: string;
        supplierId: string | null;
        category: string | null;
        quotePrice: Prisma.Decimal | null;
        actualPrice: Prisma.Decimal | null;
        profit: Prisma.Decimal | null;
        quotationId: string;
        priceDetails: Prisma.JsonValue | null;
        supplierContact: string | null;
        supplierName: string | null;
        confirmationNo: string | null;
        details: string | null;
        date: Date | null;
        label: string | null;
        guideId: string | null;
        bookingId: string | null;
    }) | null>;
    getFinalItineraryItemsByBookingId(bookingId: string): Promise<FinalItineraryItem[]>;
    createFinalItineraryItem(bookingId: string, data: Omit<FinalItineraryItem, 'id' | 'bookingId' | 'createdAt' | 'updatedAt' | 'booking'>): Promise<FinalItineraryItem>;
    updateFinalItineraryItem(itemId: string, data: Partial<Omit<FinalItineraryItem, 'id' | 'bookingId' | 'createdAt' | 'updatedAt' | 'booking'>>): Promise<FinalItineraryItem>;
    deleteFinalItineraryItem(itemId: string): Promise<FinalItineraryItem>;
    generateInitialFinalItineraryForBooking(bookingId: string): Promise<FinalItineraryItem[]>;
}
export {};
//# sourceMappingURL=bookingRepository.d.ts.map