import { Attraction } from "../../interfaces/Attraction";
export declare class AttractionRepository {
    createAttraction(data: Attraction): Promise<{
        prices: {
            id: string;
            category: string | null;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
            attractionId: string | null;
        }[];
    } & {
        id: string;
        name: string | null;
        description: string | null;
        updatedAt: Date;
        surchargeDates: Date[];
        closedDates: Date[];
        supplierId: string | null;
        location: string | null;
        terms: string | null;
        applyFridays: boolean | null;
        applySaturdays: boolean | null;
        applySundays: boolean | null;
    }>;
    getAttractions(): Promise<({
        prices: {
            id: string;
            category: string | null;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
            attractionId: string | null;
        }[];
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
    } & {
        id: string;
        name: string | null;
        description: string | null;
        updatedAt: Date;
        surchargeDates: Date[];
        closedDates: Date[];
        supplierId: string | null;
        location: string | null;
        terms: string | null;
        applyFridays: boolean | null;
        applySaturdays: boolean | null;
        applySundays: boolean | null;
    })[]>;
    getAttractionById(id: string): Promise<({
        prices: {
            id: string;
            category: string | null;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
            attractionId: string | null;
        }[];
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
    } & {
        id: string;
        name: string | null;
        description: string | null;
        updatedAt: Date;
        surchargeDates: Date[];
        closedDates: Date[];
        supplierId: string | null;
        location: string | null;
        terms: string | null;
        applyFridays: boolean | null;
        applySaturdays: boolean | null;
        applySundays: boolean | null;
    }) | null>;
    updateAttraction(id: string, data: Attraction): Promise<{
        prices: {
            id: string;
            category: string | null;
            paxType: string | null;
            costPrice: import("@prisma/client/runtime/library").Decimal | null;
            optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
            attractionId: string | null;
        }[];
        supplier: {
            id: string;
            email: string | null;
            companyName: string | null;
            category: string | null;
            contactPerson: string | null;
            designation: string | null;
            contactNo: string | null;
            companyAddress: string | null;
        } | null;
    } & {
        id: string;
        name: string | null;
        description: string | null;
        updatedAt: Date;
        surchargeDates: Date[];
        closedDates: Date[];
        supplierId: string | null;
        location: string | null;
        terms: string | null;
        applyFridays: boolean | null;
        applySaturdays: boolean | null;
        applySundays: boolean | null;
    }>;
    deleteAttraction(id: string): Promise<void>;
}
//# sourceMappingURL=attractionRepository.d.ts.map