"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const prismaClient_1 = __importDefault(require("../config/prismaClient")); // ✅ Adjusted path
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const seedAdmin = () => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const existingAdmin = yield prismaClient_1.default.admin.findUnique({
            where: { email: "admin@example.com" },
        });
        if (!existingAdmin) {
            const hashedPassword = yield bcryptjs_1.default.hash("Admin@123", 10);
            yield prismaClient_1.default.admin.create({
                data: {
                    name: "Admin",
                    email: "admin@example.com",
                    password: hashedPassword,
                    role: "admin",
                },
            });
            console.log("✅ Default Admin Created!");
        }
        else {
            console.log("✅ Default Admin Already Exists!");
        }
    }
    catch (error) {
        console.error("❌ Error seeding admin:", error);
    }
    finally {
        yield prismaClient_1.default.$disconnect();
    }
});
seedAdmin();
