"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authorizeRole = void 0;
const authorizeRole = (allowedRoles) => {
    return (req, res, next) => {
        console.log("🔍 Checking Role:", req.currentUserRole);
        console.log("🔍 Allowed Roles:", allowedRoles);
        if (!req.currentUserRole || !allowedRoles.includes(req.currentUserRole)) {
            console.error("❌ Access Denied. Current Role:", req.currentUserRole);
            res.status(403).json({
                success: false,
                message: "Access denied: Insufficient permissions",
            });
            return;
        }
        console.log("✅ Role Authorized:", req.currentUserRole);
        next();
    };
};
exports.authorizeRole = authorizeRole;
//# sourceMappingURL=roleMiddleware.js.map