import { Supplier } from "./Supplier";
export interface Room {
    id?: string;
    hotelId: string;
    hotel?: Hotel;
    category?: string;
    pax?: number;
    costPrice?: number;
    optionalPrice?: number;
    pricePerNight?: number;
    extraBedAdult?: number;
    extraBedChild?: number;
    breakfastAdult?: number;
    breakfastChild?: number;
    surcharge?: number;
    maxPax?: number;
    extraBeds?: number;
}
export interface HotelPrice {
    id?: string;
    hotelId: string;
    hotel?: Hotel;
    category?: string;
    pax?: string;
    costPrice?: number;
    optionalPrice?: number;
}
export interface Hotel {
    id?: string;
    name: string;
    location?: string;
    starRating?: string;
    tourismTax?: string;
    stateTax?: string;
    address?: string;
    phone?: string;
    description?: string;
    termsAndConditions?: string;
    supplierId: string;
    supplier?: Supplier;
    rooms?: Room[];
    price?: HotelPrice[];
    surcharge?: Record<string, any>;
    closedDates?: Record<string, any>;
}
//# sourceMappingURL=Hotel.d.ts.map