"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TourController = void 0;
const userTourService_1 = require("../../services/user/userTourService");
const tourService = new userTourService_1.TourService();
class TourController {
    async getTours(req, res, next) {
        try {
            const tours = await tourService.getTours();
            res.json(tours);
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
    async getTourById(req, res, next) {
        try {
            const tour = await tourService.getTourById(req.params.id);
            if (!tour) {
                //Use return statement because is not error
                return res.status(404).json({ message: 'Tour not found' });
            }
            res.json(tour);
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
}
exports.TourController = TourController;
//# sourceMappingURL=userTourController.js.map