"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.userLogin = void 0;
const userService = __importStar(require("../../services/user/userLoginService"));
const userLogin = async (req, res, next) => {
    var _a;
    try {
        const { email, password } = req.body;
        console.log(req.body, "User in controller");
        if (!email || !password) {
            res.status(400).json({
                success: false,
                message: "Email and password are required",
            });
            return;
        }
        const { accessToken, refreshToken, user } = await userService.userLogin({
            email,
            password,
        });
        console.log("User Login Successful:", { email, accessToken, user });
        // ✅ Set Tokens in Response Headers
        res.setHeader("x-access-token", accessToken);
        res.setHeader("x-refresh-token", refreshToken);
        // ✅ Send JSON Response (Returning All Fields)
        res.status(200).json({
            success: true,
            message: "User login successful",
            user: {
                id: user.id,
                name: user.name,
                email: user.email,
                mobile: user.mobile,
                empCode: user.empCode,
                empId: user.empId,
                teamId: user.teamId,
                teamName: (_a = user.team) === null || _a === void 0 ? void 0 : _a.name,
                agentPrivilege: user.agentPrivilege,
                inactive: user.inactive,
                createdAt: user.createdAt,
                updatedAt: user.updatedAt,
                role: user.role,
            },
            accessToken,
            refreshToken,
        });
    }
    catch (error) {
        console.error("❌ Error in userLogin controller:", error);
        next(error); // ✅ Properly pass errors to Express error handler
    }
};
exports.userLogin = userLogin;
//# sourceMappingURL=userLoginController.js.map