"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuideController = void 0;
const userGuideService_1 = require("../../services/user/userGuideService");
const guideService = new userGuideService_1.GuideService();
class GuideController {
    async getGuides(req, res, next) {
        try {
            const guides = await guideService.getGuides();
            res.json(guides);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
            next(error);
        }
    }
    async getGuideById(req, res, next) {
        try {
            const guide = await guideService.getGuideById(req.params.id);
            if (!guide) {
                res.status(404).json({ message: "Guide not found" });
                return;
            }
            res.json(guide);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
            next(error);
        }
    }
}
exports.GuideController = GuideController;
//# sourceMappingURL=userGuideController.js.map