"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAssessmentController = void 0;
class UserAssessmentController {
    constructor(userAssessmentService) {
        this.userAssessmentService = userAssessmentService;
    }
    async getAllAssessments(req, res) {
        try {
            const userId = req.currentUser; // Get user ID from authentication middleware
            const assessments = await this.userAssessmentService.getAllAssessments(userId);
            return res.status(200).json(assessments || []);
        }
        catch (error) {
            console.error("Error fetching assessments:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    }
    async getAssessmentById(req, res) {
        try {
            const { id } = req.params;
            const assessment = await this.userAssessmentService.getAssessmentById(id);
            return res.status(200).json(assessment || []);
        }
        catch (error) {
            console.error("Error fetching assessment by ID:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    }
}
exports.UserAssessmentController = UserAssessmentController;
//# sourceMappingURL=userAssessmentContoller.js.map